﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Drawing;
using System.Windows.Forms;

namespace App
{
    /// <summary>
    /// ログメッセージ出力クラス。
    /// </summary>
    public static class MessageLogger
    {
        //-----------------------------------------------------------------
        // 情報メッセージ
        /// <summary>
        /// 情報メッセージ出力。
        /// </summary>
        public static void WriteInformation(string message)
        {
//            MainFrame.SynchronizationContext.Send(_ => WriteMessage(0, message), null);
        }

        /// <summary>
        /// 情報メッセージ出力。
        /// </summary>
        public static void WriteInformation(string format, params object[] args)
        {
            WriteInformation(string.Format(format, args));
        }

        /// <summary>
        /// 情報メッセージ出力。
        /// </summary>
        public static void WriteInformationRes(string stringID)
        {
            WriteInformation(StringResource.Get(stringID));
        }

        /// <summary>
        /// 情報メッセージ出力。
        /// </summary>
        public static void WriteInformationRes(string stringID, params object[] args)
        {
            WriteInformation(StringResource.Get(stringID, args));
        }

        //-----------------------------------------------------------------
        // 警告メッセージ
        /// <summary>
        /// 警告メッセージ出力。
        /// </summary>
        public static void WriteWarning(string message)
        {
//            MainFrame.SynchronizationContext.Send(_ => WriteMessage(1, message), null);
        }

        /// <summary>
        /// 警告メッセージ出力。
        /// </summary>
        public static void WriteWarning(string format, params object[] args)
        {
            WriteWarning(string.Format(format, args));
        }

        /// <summary>
        /// 警告メッセージ出力。
        /// </summary>
        public static void WriteWarningRes(string stringID)
        {
            WriteWarning(StringResource.Get(stringID));
        }

        /// <summary>
        /// 警告メッセージ出力。
        /// </summary>
        public static void WriteWarningRes(string stringID, params object[] args)
        {
            WriteWarning(StringResource.Get(stringID, args));
        }

        //-----------------------------------------------------------------
        // エラーメッセージ
        /// <summary>
        /// エラーメッセージ出力。
        /// </summary>
        public static void WriteError(string message)
        {
//            MainFrame.SynchronizationContext.Send(_ => WriteMessage(2, message), null);
        }

        /// <summary>
        /// エラーメッセージ出力。
        /// </summary>
        public static void WriteError(string format, params object[] args)
        {
            WriteError(string.Format(format, args));
        }

        /// <summary>
        /// エラーメッセージ出力。
        /// </summary>
        public static void WriteErrorRes(string stringID)
        {
            WriteError(StringResource.Get(stringID));
        }

        /// <summary>
        /// エラーメッセージ出力。
        /// </summary>
        public static void WriteErrorRes(string stringID, params object[] args)
        {
            WriteError(StringResource.Get(stringID, args));
        }

        //-----------------------------------------------------------------
        // 汎用メッセージ
        /// <summary>
        /// 汎用メッセージ出力。
        /// </summary>
        public static void WriteMessage(int imageIndex, string message)
        {
            ////// どこから呼ばれるか分からないので念のためチェック
            ////if (TheApp.MainFrame == null) { return; }

            ////// テキスト
            ////Color textColor = SystemColors.WindowText;
            ////switch (imageIndex)
            ////{
            ////    // 情報
            ////    case 0:
            ////        textColor = SystemColors.WindowText;
            ////        break;
            ////    // 警告
            ////    case 1:
            ////        textColor = Color.OrangeRed;
            ////        break;
            ////    // エラー
            ////    case 2:
            ////        textColor = Color.Red;
            ////        break;

            ////    default:
            ////        break;
            ////}

            ////// メッセージクリア
            ////UILogView lvw = TheApp.MainFrame.LogView;

            ////// 選択状態解除
            ////lvw.ClearSelection();

            ////// 項目追加
            ////lvw.WriteLine(message, textColor, imageIndex);
        }

        //-----------------------------------------------------------------
        // メッセージ操作
        /// <summary>
        /// メッセージをクリア。
        /// </summary>
        public static void ClearMessage()
        {
            ////if (TheApp.MainFrame == null) { return; }

            ////// 注意：Begin/EndUpdate で挟まないと、何故か NullHandle 例外が送出される
            ////UILogView lvw = TheApp.MainFrame.LogView;
            ////lvw.Clear();
        }

        /// <summary>
        /// 全てのメッセージを選択。
        /// </summary>
        public static void SelectAllMessage()
        {
            ////if ( TheApp.MainFrame==null )
            ////    return;

            ////TheApp.MainFrame.LogView.SelectAll();
        }

        /// <summary>
        /// 選択メッセージをクリップボードにコピー。
        /// </summary>
        public static void CopySelectedMessage()
        {
            ////if (TheApp.MainFrame == null) { return; }

            ////// コピーする項目をリストアップ
            ////string text = TheApp.MainFrame.LogView.GetSelectedText();

            ////Clipboard.SetDataObject( text, true );
        }

        private delegate void WriteMessageDelegate(int imageIndex, string message);
    }
}
