﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace App.Data
{
    /// <summary>
    /// 読み取り専用リストクラス。
    /// </summary>
    public class ReadOnlyList<TType> : ReadOnlyCollection<TType>
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ReadOnlyList(IList<TType> list)
            : base(list)
        {
        }

        /// <summary>
        /// 要素内容を配列に変換。
        /// </summary>
        public TType[] ToArray()
        {
            TType[] array = new TType[this.Count];
            for (int i = 0; i < array.Length; i++)
            {
                array[i] = this[i];
            }
            return array;
        }
    }
}
