﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EffectMaker.DataModelMaker.UIControls.VersionEditor
{
    /// <summary>
    /// Dialog class for inputting version number.
    /// </summary>
    public partial class VersionInputDialog : Form
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public VersionInputDialog()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Get or set the version.
        /// </summary>
        public Version Version
        {
            get
            {
                return new Version(
                    (int)this.numericMajor.Value,
                    (int)this.numericMinor.Value,
                    (int)this.numericBuild.Value,
                    (int)this.numericRevision.Value);
            }

            set
            {
                this.numericMajor.Value = value.Major;
                this.numericMinor.Value = value.Minor;
                this.numericBuild.Value = value.Build;
                this.numericRevision.Value = value.Revision;
            }
        }

        /// <summary>
        /// Get or set a delegation for determine if the input version is valid.
        /// </summary>
        public Func<Version, bool> VersionValidator { get; set; }

        /// <summary>
        /// Handle FormClosing event for the dialog.
        /// </summary>
        /// <param name="e">The event arguments.</param>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK &&
                this.VersionValidator != null &&
                this.VersionValidator(this.Version) == false)
            {
                e.Cancel = true;
            }

            base.OnFormClosing(e);
        }

        /// <summary>
        /// Handle Click event for the OK button.
        /// </summary>
        /// <param name="sender">The sender of the event.</param>
        /// <param name="e">The event arguments.</param>
        private void OnOKButtonClicked(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        /// <summary>
        /// Handle Enter event for the numeric up down controls.
        /// </summary>
        /// <param name="sender">The sender of the event.</param>
        /// <param name="e">The event arguments.</param>
        private void OnEnterNumericUpDown(object sender, EventArgs e)
        {
            var numericUpDown = sender as NumericUpDown;
            if (numericUpDown == null)
            {
                return;
            }

            numericUpDown.Select(0, numericUpDown.Text.Length);
        }
    }
}
