﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.ComponentModel;

using EffectMaker.Foundation.Interfaces;

using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;

namespace EffectMaker.DataModelMaker.UIControls.DataModelEditor
{
    /// <summary>
    /// Editor user control class for data model include file.
    /// </summary>
    public partial class RuntimeDataModelIncludeFileEditor : UIUserControl
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public RuntimeDataModelIncludeFileEditor()
        {
            this.InitializeComponent();

            this.Bindings.Add(new Binder(this, "FileName", "File"));
            this.Bindings.Add(new Binder(this, "OnCommitEditingExecutable", "OnCommitEditingExecutable"));
            this.Bindings.Add(new Binder(this, "OnCancelEditingExecutable", "OnCancelEditingExecutable"));
        }

        /// <summary>
        /// Get or set the file name of the include file.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public string FileName
        {
            get { return this.txtName.Text; }
            set { this.txtName.Text = value; }
        }

        /// <summary>
        /// Get or set the executable for committing edited contents.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public IExecutable OnCommitEditingExecutable { get; set; }

        /// <summary>
        /// Get or set the executable for canceling edited contents.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public IExecutable OnCancelEditingExecutable { get; set; }

        /// <summary>
        /// Confirm the edited contents and commit the modification to the data source.
        /// </summary>
        /// <returns>
        /// False if there are problems in the modifications and should cancel the action.
        /// </returns>
        public bool CommitEditing()
        {
            if (this.OnCommitEditingExecutable != null)
            {
                this.OnCommitEditingExecutable.Execute(new KeyValuePair<string, object>[]
                {
                    new KeyValuePair<string, object>("File", this.FileName)
                });
            }

            return true;
        }

        /// <summary>
        /// Cancel the edited contents.
        /// </summary>
        /// <param name="deleteContents">True to delete the editing contents.</param>
        public void CancelEditing(bool deleteContents)
        {
            if (deleteContents == true &&
                this.OnCancelEditingExecutable != null)
            {
                this.OnCancelEditingExecutable.Execute(null);
            }
        }
    }
}
