﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using System.Linq;
using System.Windows.Forms;

using EffectMaker.DataModelMaker.Core.DataTypes;

using EffectMaker.DataModelMaker.UIControls.Properties;

using EffectMaker.Foundation.Interfaces;

using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;

namespace EffectMaker.DataModelMaker.UIControls.DataModelEditor
{
    /// <summary>
    /// The user control for input the namespace and name of a editor-side data model.
    /// </summary>
    public partial class DataModelNameInputControl : UIUserControl
    {
        /// <summary>The suggestion strings for the namespace text box.</summary>
        private AutoCompleteStringCollection namespaceSuggestions =
            new AutoCompleteStringCollection();

        /// <summary>
        /// Constructor.
        /// </summary>
        public DataModelNameInputControl()
        {
            this.InitializeComponent();

            this.namespaceSuggestions.AddRange(TypeManager.EditorNamespaces.ToArray());
            this.txtNamespace.AutoCompleteCustomSource = this.namespaceSuggestions;

            this.Bindings.Add(new Binder(this, "OnCreateDataModelExecutable", "OnCreateDataModelExecutable"));
        }

        /// <summary>
        /// Get or set the namespace.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public string Namespace
        {
            get { return this.txtNamespace.Text; }
            set { this.txtNamespace.Text = value; }
        }

        /// <summary>
        /// Get or set the data model name.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public string DataModelName
        {
            get { return this.txtName.Text; }
            set { this.txtName.Text = value; }
        }

        /// <summary>
        /// Get or set the executable for creating a new data model.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public IExecutable OnCreateDataModelExecutable { get; set; }

        /// <summary>
        /// Confirm the edited contents and commit the modification to the data source.
        /// </summary>
        /// <returns>
        /// False if there are problems in the modifications and should cancel the action.
        /// </returns>
        public bool CreateDataModel()
        {
            if (string.IsNullOrEmpty(this.DataModelName) == true)
            {
                MessageBox.Show(
                    Properties.Resources.WarningDataModelNameIsEmpty,
                    Properties.Resources.WarningMessageBoxTitle,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Exclamation);
                return false;
            }

            if (this.OnCreateDataModelExecutable != null)
            {
                var parameters = new object[]
                {
                    this.Namespace,
                    this.DataModelName,
                    true
                };

                this.OnCreateDataModelExecutable.Execute(parameters);
                if ((bool)parameters[2] == false)
                {
                    MessageBox.Show(
                        Properties.Resources.WarningDataModelNameIsRegistered,
                        Properties.Resources.WarningMessageBoxTitle,
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Exclamation);
                    return false;
                }
            }

            return true;
        }
    }
}
