﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EffectMaker.DataModelMaker.UIControls.DataModelEditor
{
    /// <summary>
    /// Dialog for creating editor-side data models.
    /// </summary>
    public partial class CreateDataModelDialog : Form
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public CreateDataModelDialog()
        {
            this.InitializeComponent();

            this.editor.Visibility = EffectMaker.UIControls.Layout.Visibility.Visible;
        }

        /// <summary>
        /// Get or set the data source for the editor.
        /// </summary>
        public object DataSource
        {
            get { return this.editor.DataContext; }
            set { this.editor.DataContext = value; }
        }

        /// <summary>
        /// Handle FormClosing event.
        /// </summary>
        /// <param name="e">The event arguments.</param>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (this.editor.CreateDataModel() == false)
                {
                    e.Cancel = true;
                }
            }

            base.OnFormClosing(e);
        }
    }
}
