﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;

using EffectMaker.Foundation.Render.Renderable;

namespace EffectMaker.DataModelMaker.UIControls.ConversionView
{
    /// <summary>
    /// Class that holds data for connector rendering.
    /// </summary>
    internal class ConnectorRenderContext : RenderContext
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="viewport">The viewport that created this render context.</param>
        public ConnectorRenderContext(Viewport viewport) :
            base(viewport)
        {
            this.ShowConnector = false;
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source to copy from.</param>
        public ConnectorRenderContext(RenderContext src) :
            base(src)
        {
        }

        /// <summary>
        /// Get or set the flag indicating whether to show connector or not.
        /// </summary>
        public bool ShowConnector { get; set; }

        /// <summary>
        /// Get or set the item that is currently connecting.
        /// </summary>
        public IConnectible ConnectingItem { get; set; }

        /// <summary>
        /// Get or set the item that is being connected.
        /// </summary>
        public IConnectible ConnectedItem { get; set; }

        /// <summary>
        /// Set data.
        /// </summary>
        /// <param name="src">The source object.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            if (base.Set(src) == false)
            {
                return false;
            }

            var mySrc = src as ConnectorRenderContext;
            if (mySrc == null)
            {
                return false;
            }

            this.ShowConnector = mySrc.ShowConnector;

            return true;
        }

        /// <summary>
        /// Clone this render context.
        /// </summary>
        /// <returns>The new render context.</returns>
        public override object Clone()
        {
            return new ConnectorRenderContext(this);
        }
    }
}
