﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Attributes;

namespace EffectMaker.DataModelMaker.Core
{
    /// <summary>
    /// Enum of asset types.
    /// </summary>
    public enum AssetTypes
    {
        //// --------- Runtime --------------

        /// <summary>
        /// エラー設定用.
        /// </summary>
        [PacketAttribute(-1, "DEAD")]
        Unknown,

        /// <summary>
        /// エミッタセット.
        /// </summary>
        [PacketAttribute(0, "ESET")]
        EmitterSet,

        /// <summary>
        /// エミッタ.
        /// </summary>
        [PacketAttribute(1, "EMTR")]
        Emitter,

        /// <summary>
        /// テクスチャ.
        /// </summary>
        [PacketAttribute(2, "TEXA")]
        Texture,

        /// <summary>
        /// プリミティブ.
        /// </summary>
        [PacketAttribute(3, "PRMA")]
        Primitive,

        /// <summary>
        /// シェーダ.
        /// </summary>
        [PacketAttribute(4, "SHDA")]
        Shader,

        //// --------- 以下 Viewer --------------

        /// <summary>
        /// プレビュー.
        /// </summary>
        [PacketAttribute(5, "PREV")]
        Preview,

        /// <summary>
        /// ビューア.
        /// </summary>
        [PacketAttribute(6, "VIEW")]
        ViewerData,

        /// <summary>
        /// ビューアモデル.
        /// </summary>
        [PacketAttribute(7, "VMDL")]
        ViewerModel,
    }
}
