﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using EffectMaker.DataModelLogic.BinaryConverters;

namespace EffectMaker.DataModelMaker.Core.Converters
{
    /// <summary>
    /// Class that stores converter information.
    /// </summary>
    public class ConverterInfo
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="converter">The converter instance.</param>
        public ConverterInfo(ConverterBase converter)
        {
            this.Converter = converter;
            this.ConverterType = converter.GetType();
            this.Namespace = this.ConverterType.Namespace;
            this.Name = this.ConverterType.Name;
            this.FullName = this.ConverterType.FullName;
        }

        /// <summary>
        /// Get the instance of the converter.
        /// </summary>
        public ConverterBase Converter { get; private set; }

        /// <summary>
        /// Get the type of the converter.
        /// </summary>
        public Type ConverterType { get; private set; }

        /// <summary>
        /// Get the namespace of the converter type.
        /// </summary>
        public string Namespace { get; private set; }

        /// <summary>
        /// Get the name of the converter.
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// Get the full name of the converter, including the namespace.
        /// </summary>
        public string FullName { get; private set; }

        /// <summary>
        /// Get the description for the converter.
        /// </summary>
        public string Description
        {
            get { return this.Converter.Description; }
        }

        /// <summary>
        /// Get the description for the output value of the converter.
        /// </summary>
        public string OutputValueDescription
        {
            get { return this.Converter.OutputValueDescription; }
        }

        /// <summary>
        /// Get the description of the input values of the converter.
        /// </summary>
        public IEnumerable<string> InputValueDescriptions
        {
            get { return this.Converter.InputValueDescriptions; }
        }
    }
}
