﻿// ========================================================================
// <copyright file="NullSafeUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    using System;

    /// <summary>
    /// Null を取りうるプロパティを安全に扱うためのユーティリティです。
    /// </summary>
    public static class NullSafeUtility
    {
        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="src">基準となるインスタンスです。</param>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        public static new bool Equals(object src, object other)
        {
            return (src == null) ? (other == null) : src.Equals(other);
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <param name="src">基準となるインスタンスです。</param>
        /// <returns>ハッシュ値です。</returns>
        public static int GetHashCode(object src)
        {
            return (src == null) ? 0 : src.GetHashCode();
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <typeparam name="TObject">オブジェクトのクラスです。</typeparam>
        /// <param name="source">このインスタンスのコピー元となるオブジェクトです。</param>
        /// <returns>このインスタンスのコピーである新しいオブジェクトです。</returns>
        public static TObject Clone<TObject>(TObject source) where TObject : class, ICloneable
        {
            return (source == null) ? null : (TObject)source.Clone();
        }
    }
}
