﻿// ========================================================================
// <copyright file="HashCalculationUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// クローン関連のユーティリティです。
    /// </summary>
    public static class HashCalculationUtility
    {
        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <param name="source">対象オブジェクトです。</param>
        /// <returns>ハッシュ値です。引数が null の場合は 0 を返します。</returns>
        public static int TryGetHashCode(object source)
        {
            if (source == null)
            {
                return 0;
            }

            return source.GetHashCode();
        }
    }
}
