﻿// ========================================================================
// <copyright file="Vector4Xml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// 4 次元のベクトルのシリアライズ用クラスです。
    /// </summary>
    [CoupledType(typeof(Vector4))]
    public class Vector4Xml : IStringSettable, ISettable
    {
        /// <summary>
        /// X 成分を取得または設定します。
        /// </summary>
        [XmlElement("x")]
        public float X { get; set; }

        /// <summary>
        /// Y 成分を取得または設定します。
        /// </summary>
        [XmlElement("y")]
        public float Y { get; set; }

        /// <summary>
        /// Z 成分を取得または設定します。
        /// </summary>
        [XmlElement("z")]
        public float Z { get; set; }

        /// <summary>
        /// W 成分を取得または設定します。
        /// </summary>
        [XmlElement("w")]
        public float W { get; set; }

        //-----------------------------------------------------------------
        // 設定
        //-----------------------------------------------------------------

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            this.Set(source as Vector4Xml);
        }

        /// <summary>
        /// Vector4Xml を設定します。
        /// </summary>
        /// <param name="source">設定する Vector4Xml です。</param>
        public void Set(Vector4Xml source)
        {
            Ensure.Argument.NotNull(source);

            this.X = source.X;
            this.Y = source.Y;
            this.Z = source.Z;
            this.W = source.W;
        }

        /// <summary>
        /// 状態を設定します。
        /// </summary>
        /// <param name="source">文字列です。</param>
        public void Set(string source)
        {
            Ensure.Argument.StringNotEmpty(source);
            string[] elements = source.Split(" ".ToCharArray());
            Ensure.Argument.True(elements.Length == 4);

            this.X = float.Parse(elements[0]);
            this.Y = float.Parse(elements[1]);
            this.Z = float.Parse(elements[2]);
            this.W = float.Parse(elements[3]);
        }

        /// <summary>
        /// 現在のオブジェクトを表す文字列を返します。
        /// </summary>
        /// <returns>現在のオブジェクトを表す文字列です。</returns>
        public override string ToString()
        {
            return string.Format("{0} {1} {2} {3}", this.X, this.Y, this.Z, this.W);
        }
    }
}
