﻿// ========================================================================
// <copyright file="TransformXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using NintendoWare.ToolDevelopmentKit;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// 3 次元のベクトルのシリアライズ用クラスです。
    /// </summary>
    [CoupledType(typeof(Transform))]
    public class TransformXml : ISettable
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public TransformXml()
        {
            this.Scale = new Vector3Xml();
            this.Rotate = new Vector3Xml();
            this.Translate = new Vector3Xml();

            this.Scale.X = 1.0f;
            this.Scale.Y = 1.0f;
            this.Scale.Z = 1.0f;
        }

        /// <summary>
        /// 拡大縮小を取得または設定します。
        /// </summary>
        public Vector3Xml Scale { get; set; }

        /// <summary>
        /// 回転を取得または設定します。
        /// </summary>
        public Vector3Xml Rotate { get; set; }

        /// <summary>
        /// 平行移動を取得または設定します。
        /// </summary>
        public Vector3Xml Translate { get; set; }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            this.Set(source as TransformXml);
        }

        /// <summary>
        /// Transform を設定します。
        /// </summary>
        /// <param name="source">設定する Transform です。</param>
        public void Set(TransformXml source)
        {
            Ensure.Argument.NotNull(source);

            this.Scale.Set(source.Scale);
            this.Rotate.Set(source.Rotate);
            this.Translate.Set(source.Translate);
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値です。</returns>
        public override int GetHashCode()
        {
            return
                this.Translate.GetHashCode() ^
                this.Scale.GetHashCode() ^
                this.Rotate.GetHashCode();
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// [sealedクラスならprivateとします。]
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        public override bool Equals(object other)
        {
            return this.Equals(other as TransformXml);
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// [sealedクラスならprivateとします。]
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        protected bool Equals(TransformXml other)
        {
            if (other == this)
            {
                return true;
            }

            if (other == null)
            {
                return false;
            }

            return
                this.Translate.Equals(other.Translate) &&
                this.Scale.Equals(other.Scale) &&
                this.Rotate.Equals(other.Rotate);
        }
    }
}
