﻿// ========================================================================
// <copyright file="FloatArrayStreamXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System;
    using NintendoWare.ToolDevelopmentKit;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// ストリームのシリアライズ用クラスです。
    /// ジェネリック型に対応して、複数の型を管理します。
    /// </summary>
    [CoupledType(
        typeof(float[]),
        typeof(FloatArrayStreamXml),
        "ForwardConvertHandler",
        "BackwardConvertHandler")]
    public class FloatArrayStreamXml : FloatStreamXml
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FloatArrayStreamXml()
        {
        }

        //-----------------------------------------------------------------
        // カスタムコンバータ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンバート関数です。
        /// </summary>
        /// <param name="src">変換もとの型です。</param>
        /// <param name="dstType">変換結果型です。</param>
        /// <param name="converter">コンバータです。</param>
        /// <returns>変換結果です。</returns>
        internal static object ForwardConvertHandler(object src, Type dstType, Converter converter)
        {
            Ensure.Argument.NotNull(src);
            Ensure.Argument.True(src is float[]);

            float[] srcArray = src as float[];

            FloatArrayStreamXml result = new FloatArrayStreamXml();
            result.Stream = ArrayUtility.CreateAndCopy(srcArray);

            return result;
        }

        /// <summary>
        /// 逆コンバート関数です。
        /// </summary>
        /// <param name="src">変換もとの型です。</param>
        /// <param name="dstType">変換結果型です。</param>
        /// <param name="converter">コンバータです。</param>
        /// <returns>変換結果です。</returns>
        internal static object BackwardConvertHandler(object src, Type dstType, Converter converter)
        {
            Ensure.Argument.NotNull(src);
            Ensure.Argument.True(src is FloatArrayStreamXml);

            FloatArrayStreamXml srcArray = src as FloatArrayStreamXml;

            float[] result = ArrayUtility.CreateAndCopyIfExist(srcArray.Stream);
            if (result == null)
            {
                result = new float[0];
            }

            return result;
        }
    }
}
