﻿// ========================================================================
// <copyright file="StringArrayMetaDataXml.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System.Collections;
    using System.Collections.Generic;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// シェーダー内のレジスタの定義を表すクラスです。
    /// </summary>
    /// <remarks>
    /// シェーダーパラメータの受け口になります。
    /// </remarks>
    [CoupledType(typeof(StringArrayMetaData))]
    public class StringArrayMetaDataXml : ArrayMetaDataXml
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public StringArrayMetaDataXml()
        {
            this.Values = new List<string>();
        }

        /// <summary>
        /// ユーザデータの型種類です。
        /// </summary>
        [XmlAttribute]
        public MetaDataKind DataKind
        {
            get
            {
                return MetaDataKind.StringSet;
            }

            set
            {
                // なにもしません。
            }
        }

        /// <summary>
        /// バイナリ化時のエンコーディング形式を取得または設定します。
        /// </summary>
        public StringMetaDataEncoding BinarizeEncoding { get; set; }

        /// <summary>
        /// データ内容のリストを取得します。
        /// </summary>
        [Overwrite(OverwriteAttribute.KindType.ListSet)]
        [XmlArrayItem("StringSet")]
        public List<string> Values { get; set; }
    }
}
