﻿// ========================================================================
// <copyright file="LogInputUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;
    using System.ComponentModel;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// ログのインターフェースです。
    /// </summary>
    public static class LogInputUtility
    {
        /// <summary>
        /// 例外の詳細情報をログ入力に追加します。
        /// </summary>
        /// <param name="logInput">ログ入力です。</param>
        /// <param name="exception">例外です。</param>
        public static void AddExceptionDetails(
            this ILogInput logInput, Exception exception)
        {
            Ensure.Argument.NotNull(logInput);
            Ensure.Argument.NotNull(exception);

            while (exception != null)
            {
                // MEMO:条件ビルドにしていますが、起動オプション等で
                // 動的に変更できてもよいかもしれません。
#if DEBUG
                logInput.AddMessage(exception.Message);
#endif
                logInput.AddMessage(exception.StackTrace);
                exception = exception.InnerException;
            }
        }
    }
}
