﻿// ========================================================================
// <copyright file="ReadOnlyListDecorator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// リストへの変更を禁止するリストデコレータです。
    /// 内容の変更は禁止できません。
    /// </summary>
    /// <typeparam name="TItem">要素のテンプレート型です。</typeparam>
    public class ReadOnlyListDecorator<TItem> : ListDecorator<TItem>, IReadOnlyList<TItem>
    {
        //-----------------------------------------------------------------
        // オブジェクトの生成
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="list">デコレーションするリストです。</param>
        public ReadOnlyListDecorator(IList<TItem> list)
            : base(list)
        {
        }

        /// <summary>
        /// 読み取り専用かどうかを示す値を取得します。
        /// </summary>
        /// <returns>読み取り専用の場合は trueです。それ以外の場合は false です。</returns>
        public override bool IsReadOnly
        {
            get
            {
                return true;
            }
        }

        //-----------------------------------------------------------------
        // 要素の取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したインデックス位置へのアクセスを行うインデクサです。
        /// </summary>
        /// <param name="index">アクセスする項目の 0 から始まるインデックスです。</param>
        /// <returns>インデックス位置の項目です。</returns>
        public override TItem this[int index]
        {
            set { throw new InvalidOperationException("ReadOnlyListDecorator.Indexer[]"); }
        }

        //-----------------------------------------------------------------
        // 要素の追加または削除
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したインデックス位置に項目を挿入します。
        /// </summary>
        /// <param name="index">項目を挿入する位置の、0 から始まるインデックス番号です。</param>
        /// <param name="item">挿入する項目です。</param>
        public override void Insert(int index, TItem item)
        {
            throw new InvalidOperationException("ReadOnlyListDecorator.Insert()");
        }

        /// <summary>
        /// 指定したインデックス位置の項目を削除します。
        /// </summary>
        /// <param name="index">削除する項目の 0 から始まるインデックスです。</param>
        public override void RemoveAt(int index)
        {
            throw new InvalidOperationException("ReadOnlyListDecorator.RemoveAt()");
        }

        /// <summary>
        /// すべての項目を削除します。
        /// </summary>
        public override void Clear()
        {
            throw new InvalidOperationException("ReadOnlyListDecorator.Clear()");
        }
    }
}
