﻿// ========================================================================
// <copyright file="ReadOnlyDictionaryDecorator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// ディクショナリーへの変更を禁止するディクショナリーデコレータです。
    /// 内容の変更は禁止できません。
    /// </summary>
    /// <typeparam name="TKey">ディクショナリー内のキーのテンプレート型です。</typeparam>
    /// <typeparam name="TValue">ディクショナリー内の値のテンプレート型です。</typeparam>
    public class ReadOnlyDictionaryDecorator<TKey, TValue> : DictionaryDecorator<TKey, TValue>
    {
        //-----------------------------------------------------------------
        // コンストラクタ
        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="dictionary">デコレーションするディクショナリーです。</param>
        public ReadOnlyDictionaryDecorator(IDictionary<TKey, TValue> dictionary)
            : base(dictionary)
        {
        }

        //-----------------------------------------------------------------
        // public プロパティ
        //-----------------------------------------------------------------

        /// <summary>
        /// 読み取り専用かどうかを示す値を取得します。
        /// </summary>
        /// <returns>読み取り専用の場合は trueです。それ以外の場合は false です。</returns>
        public override bool IsReadOnly
        {
            get { return true; }
        }

        /// <summary>
        /// 指定したキーを持つ要素を取得または設定します。
        /// </summary>
        /// <param name="key">取得または設定する要素のキーです。</param>
        /// <returns>指定したキーを持つ要素です。</returns>
        public override TValue this[TKey key]
        {
            set { throw new InvalidOperationException("ReadOnlyDictionaryDecorator.Indexer[]"); }
        }

        //-----------------------------------------------------------------
        // public メソッド
        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したキーおよび値を持つ要素を追加します。
        /// </summary>
        /// <param name="key">追加する要素のキーです。</param>
        /// <param name="value">追加する要素の値です。</param>
        public override void Add(TKey key, TValue value)
        {
            throw new InvalidOperationException("ReadOnlyDictionaryDecorator.Add");
        }

        /// <summary>
        /// すべての要素を削除します。
        /// </summary>
        public override void Clear()
        {
            throw new InvalidOperationException("ReadOnlyDictionaryDecorator.Clear");
        }

        /// <summary>
        /// 指定したキーを持つ値を削除します。
        /// </summary>
        /// <param name="key">削除する要素のキーです。</param>
        /// <returns>
        /// 要素が見つかり正常に削除された場合は true です。それ以外の場合は false です。
        /// </returns>
        public override bool Remove(TKey key)
        {
            throw new InvalidOperationException("ReadOnlyDictionaryDecorator.Remove");
        }
    }
}
