﻿// ========================================================================
// <copyright file="NamedObjectListDecorator.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Linq;
    using System.Text;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 名前引きができるリストコレクションです。
    /// </summary>
    /// <typeparam name="TItem">テンプレート型です。</typeparam>
    public class NamedObjectListDecorator<TItem> : KeyedListDecorator<string, TItem>
        where TItem : class, INamedObject
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="list">デコレート対象のIListを持つリストオブジェクトです。</param>
        public NamedObjectListDecorator(IList<TItem> list)
            : base(list, (item) => item.Name)
        {
        }
    }
}
