﻿// ========================================================================
// <copyright file="IMultipleItemChangeableCollection.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================
namespace NintendoWare.ToolDevelopmentKit.Collections
{
    using System.Collections.Generic;
    using System.Collections.Specialized;
    using System.ComponentModel;
    using NintendoWare.ToolDevelopmentKit.ComponentModel;

    /// <summary>
    /// 複数要素を変更できるコレクションのインタフェースです。
    /// </summary>
    /// <typeparam name="TItem">リスト内の要素のテンプレート型です。</typeparam>
    public interface IMultipleItemChangeableCollection<TItem>
    {
        /// <summary>
        /// 項目を追加します。
        /// </summary>
        /// <param name="collection">末尾に要素が追加されるコレクションです。
        /// <remarks>
        /// コレクション自体を null にすることはできません。
        /// </remarks>
        /// </param>
        void AddRange(IEnumerable<TItem> collection);
    }
}
