﻿// ========================================================================
// <copyright file="BaseMessage.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.IO;
using System.Text;
using NWCore.Protocols;

namespace NWCore.Viewer
{
    /// <summary>
    /// 基本メッセージ
    /// </summary>
    public abstract class BaseMessage
    {
        /// <summary>ヘッダの書き出し</summary>
        public void WriteHeader(Protocol4FWriter writer)
        {
            (new Header(Type, Size, ArraySize)).Write(writer);
        }

        /// <summary>タイプ</summary>
        protected abstract MessageType Type { get; }

        /// <summary>サイズ</summary>
        protected abstract int Size { get; }

        /// <summary>配列サイズ</summary>
        protected abstract int ArraySize { get; }

        /// <summary>合計サイズ</summary>
        public virtual int TotalSize
        {
            get { return this.Size + this.ArraySize; }
        }

        /// <summary>PushMessageで同じパケットを上書きでPushするか？(DEF:=true)</summary>
        public virtual bool IsOverrideOnPush
        {
            get { return true; }
        }

        /// <summary>書き出し</summary>
        public abstract void Write(Protocol4FWriter writer);

        /// <summary>メッセージ送信</summary>
        protected void Push()
        {
            MCSManager.SendMessage(this);
        }
    }
}
