﻿// ========================================================================
// <copyright file="EnvConfigDataXml.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.DataModel.Major_1.Minor_5.Build_0.Revision_0;

namespace NWCore.Serializer.Major_1.Minor_5.Build_0.Revision_0
{
    /// <summary>
    /// 全エミッタ共通データのシリアライズ用クラスです
    /// </summary>
    [XmlRoot("root")]
    public class EnvConfigDataXml
    {
        #region Classes

        /// <summary>
        /// エミッタセット用コンフィグ設定用
        /// </summary>
        [XmlType("EmitterSetData")]
        public class EmitterSetConfigXml
        {
            /// <summary>
            /// コンストラクタ
            /// </summary>
            public EmitterSetConfigXml()
            {
                this.EmitterGameDatas = new List<EmitterGameData>();
                this.PreviewGameDatas = new List<PreviewGameData>();
            }

            /// <summary>
            /// エミッタセットのファイルパス
            /// </summary>
            [XmlAttribute]
            public string Name { get; set; }

            /// <summary>
            /// エミッタセットの表示、非表示
            /// </summary>
            [XmlAttribute]
            public bool IsShow { get; set; }

            /// <summary>
            /// エミッタセットの表示、非表示
            /// </summary>
            [XmlArrayItem("EmitterConfig")]
            public List<EmitterGameData> EmitterGameDatas
            {
                get;
                set;
            }

            /// <summary>
            /// プレビューの表示、非表示
            /// </summary>
            [XmlArrayItem("PreviewConfig")]
            public List<PreviewGameData> PreviewGameDatas
            {
                get;
                set;
            }
        }

        #endregion

        #region Construtors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EnvConfigDataXml()
        {
            this.ConfigData        = new EnvConfigData();
            this.PrevDataList      = new List<GameConfigDataXml>();
            this.EmitterSetConfigs = new List<EmitterSetConfigXml>();

            this.ConfigData.Initialize();
        }

        #endregion

        #region Properties

        /// <summary>
        /// Preview file paths
        /// </summary>
        [XmlArrayItem("PrevDataList")]
        public List<GameConfigDataXml> PrevDataList
        {
            get;
            set;
        }

        /// <summary>
        /// Emitter set config data
        /// </summary>
        [XmlArrayItem( "EmitterSetConfigs" )]
        public List<EmitterSetConfigXml> EmitterSetConfigs
        {
            get;
            set;
        }

        /// <summary>
        /// コンフィグ設定データ
        /// </summary>
        public EnvConfigData ConfigData
        {
            get;
            set;
        }

        #endregion

    }
}
