﻿// ========================================================================
// <copyright file="EmitterGameData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// エミッタ用ゲーム設定データ
    /// </summary>
    public class EmitterGameData : BaseDataModel<EmitterGameData>
    {
        #region Properties

        /// <summary>
        /// このエミッタは有効か？
        /// </summary>
        public bool DispEmitter { get; set; }

        /// <summary>
        /// 放出レートのスケール値
        /// </summary>
        public float EmissionRatio { get; set; }

        /// <summary>
        /// 放出間隔のスケール値
        /// </summary>
        public float EmissionInterval { get; set; }

        /// <summary>
        /// ライフのスケール値
        /// </summary>
        public float Life { get; set; }

        #endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EmitterGameData()
        {
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EmitterGameData(EmitterGameData source)
        {
            Ensure.Argument.NotNull(source);
            this.Set(source);
        }

        #endregion

        #region Utility

        /// <summary>
        /// クローン
        /// </summary>
        public override EmitterGameData Clone()
        {
            return new EmitterGameData(this);
        }

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.DispEmitter = true;
            this.EmissionRatio = 1.0f;
            this.EmissionInterval = 1.0f;
            this.Life = 1.0f;
        }

        /// <summary>
        /// 設定します。
        /// </summary>
        public override void Set(EmitterGameData source)
        {
            Ensure.Argument.NotNull(source);

            this.DispEmitter = source.DispEmitter;
            this.EmissionRatio = source.EmissionRatio;
            this.EmissionInterval = source.EmissionInterval;
            this.Life = source.Life;
        }

        #endregion
    }

}
