﻿// ========================================================================
// <copyright file="EmitterData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel.Major_0.Minor_0.Build_0.Revision_0
{
    /// <summary>
    /// 固定値
    /// </summary>
    public static class Constances
    {
        #region ColorType

        /// <summary>
        /// カラータイプ用
        /// gHostIOColorTypeNames と並びを合わせる必要があります。
        /// </summary>
        public enum ColorType
        {
            /// <summary>00:固定</summary>
            ConstColorNoTex,
            /// <summary>01:アニメ</summary>
            ColorAnimNoTex,
            /// <summary>02:ランダム</summary>
            RandomColorNoTex,
            /// <summary>03:固定　　 ×　TEX</summary>
            ModulateNoAnim,
            /// <summary>04:アニメ　 ×　TEX</summary>
            Modulate3ColorsAnim,
            /// <summary>05:ランダム ×　TEX</summary>
            ModulateRandomColor,
            /// <summary>06:固定１    ×　TEX ＋ 固定２　  ×　(1-TEX)</summary>
            TwoColorInterpolateNoAnim,
            /// <summary>07:アニメ　  ×　TEX ＋ 固定　　   ×　(1-TEX)</summary>
            Inv2ColorInterpolate3ColorsAnim,
            /// <summary>08:固定　 　  ×　TEX ＋ アニメ  　×　(1-TEX)</summary>
            TwoColorInterpolate3ColorsAnim,
            /// <summary>09:ランダム 　×　TEX ＋ 固定　　   ×　(1-TEX)</summary>
            Inv2ColorInterpolateRandomColor,
            /// <summary>10:固定　 　  ×　TEX ＋ ランダム ×　(1-TEX)</summary>
            TwoColorInterpolateRandomColor,
            /// <summary>11:固定　 　  ×　TEX ＋ 固定</summary>
            AddConst,
            /// <summary>12:固定　 　  ×　TEX ＋ ランダム</summary>
            AddRandom,
            /// <summary>13:固定　 　  ×　TEX ＋ アニメ</summary>
            AddAnim,
        }

        /// <summary>
        /// カラータイプ名
        /// ColorType と並びを合わせる必要があります。
        /// </summary>
        static readonly string[] gHostIOColorTypeNames = new string[]
        {
            /*00*/"ConstColorNoTex" ,
            /*01*/"ColorAnimNoTex" ,
            /*02*/"RandomColorNoTex" ,
            /*03*/"Modulate(no anim)" ,
            /*04*/"Modulate(3 colors anim)" ,
            /*05*/"Modulate(random color)" ,
            /*06*/"2ColorInterpolate(no anim)" ,
            /*07*/"Inv2ColorInterpolate(3 colors anim)" ,
            /*08*/"2ColorInterpolate(3 colors anim)" ,
            /*09*/"Inv2ColorInterpolate(random color)" ,
            /*10*/"2ColorInterpolate(random color)" ,
            /*11*/"AddConst" ,
            /*12*/"AddRandom" ,
            /*13*/"AddAnim" ,
        };

        #endregion

        #region ColorInheritType

        /// <summary>
        /// カラー継承タイプ
        /// gHostIOColorInheritTypeNames の並びとあわせる必要があります。
        /// </summary>
        public enum ColorInheritType
        {
            /// <summary>00:継承カラー</summary>
            InheritanceColorNoTex,
            /// <summary>01:継承カラー　×　TEX</summary>
            ModulateNoAnim,
            /// <summary>02:継承カラー　×　TEX　＋　固定カラー ×（1-TEX）</summary>
            TwoColorInterpolateNoAnim,
            /// <summary>03:固定カラー　×　TEX　＋　継承カラー ×（1-TEX）</summary>
            Inv2ColorInterpolateNoAnim,
            /// <summary>04:固定カラー　×　TEX　＋　継承カラー</summary>
            InheritanceColorAdd,
        }

        /// <summary>
        /// カラー継承タイプ名
        /// ColorInheritType の並びとあわせる必要があります。
        /// </summary>
        static readonly string[] gHostIOColorInheritTypeNames = new string[]
        {
            /*00*/"InheritanceColorNoTex" ,
            /*01*/"Modulate(no anim)" ,
            /*02*/"2ColorInterpolate(no anim)" ,
            /*03*/"Inv2ColorInterpolate(no anim)" ,
            /*04*/"InheritanceColorAdd" ,
        };

        #endregion

        #region Utilites

        /// <summary>
        /// カラータイプ名
        /// </summary>
        public static string GetColorTypeName(ColorType type)
        {
            Debug.Assert(gHostIOColorTypeNames.Length > (int)type,
                String.Format("ERROR : 未知のカラータイプです。{0}", type.ToString()));
            //
            return gHostIOColorTypeNames[(int)type];
        }

        /// <summary>
        /// カラータイプ名でカラータイプを設定します。
        /// </summary>
        /// <param name="name"></param>
        public static ColorType SetColorTypeName(string name)
        {
            int index = 0;
            foreach (var item in gHostIOColorTypeNames)
            {
                if (name.Equals(item, StringComparison.CurrentCultureIgnoreCase))
                {
                    return (ColorType)index;
                }
                index++;
            }
            // ここに来たらエラーです。
//            Debug.Assert(false, String.Format("ERROR : 未知のカラータイプ名です。{0}", name));
            string msg = String.Format("ERROR : 未知のカラータイプ名です。{0}", name);
            DebugConsole.DebugConsole.Instance.WriteLine(msg);
            Trace.WriteLine(msg);
            return ColorType.ModulateNoAnim;
        }

        /// <summary>
        /// カラー継承タイプ名
        /// </summary>
        public static string GetColorInheritTypeNames(ColorInheritType type)
        {
            Debug.Assert(gHostIOColorInheritTypeNames.Length > (int)type,
                String.Format("ERROR : 未知のカラータイプです。{0}", type.ToString()));
            //
            return gHostIOColorInheritTypeNames[(int)type];
        }

        /// <summary>
        /// カラー継承タイプ名でカラー継承タイプを設定します。
        /// </summary>
        public static ColorInheritType SetColorInheritTypeNames(string name)
        {
            int index = 0;
            foreach (var item in gHostIOColorInheritTypeNames)
            {
                if (name.Equals(item, StringComparison.CurrentCultureIgnoreCase))
                {
                    return (ColorInheritType)index;
                }
                index++;
            }
            // ここに来たらエラーです。
            Debug.Assert(false, String.Format("ERROR : 未知のカラータイプ名です。{0}", name));
            return 0;
        }

        #endregion
    }

}
