﻿// ========================================================================
// <copyright file="FieldConvergenceData.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Diagnostics;
using NintendoWare.ToolDevelopmentKit;

namespace NWCore.DataModel
{
    /// <summary>
    /// 収束フィールド
    /// </summary>
    public sealed class FieldConvergenceData : BaseDataModel<FieldConvergenceData>
    {
        #region Properties

        /// <summary>
        /// 位置
        /// </summary>
        public Vector3 Position
        {
            get;
            set;
        }

        /// <summary>
        /// 割合
        /// </summary>
        public float Ratio
        {
            get;
            set;
        }

        /// <summary>
        /// エミッタに追従
        /// </summary>
        public bool FollowEmitter
        {
            get;
            set;
        }

        #endregion

        #region Construtors

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public FieldConvergenceData()
        {
            this.Position = new Vector3();
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="source">コピー元のベクトル</param>
        public FieldConvergenceData(FieldConvergenceData source)
            : this()
        {
            this.Set(source);
        }

        #endregion

        #region Utility Functions

        /// <summary>
        /// 初期化
        /// </summary>
        public override void Initialize()
        {
            this.Position.Set( 0.0f, 0.0f, 0.0f );
            this.Ratio = 0.0f;
            this.FollowEmitter = false;
        }

        /// <summary>
        /// ベクトルを設定します
        /// </summary>
        /// <param name="source">設定するベクトルです</param>
        public override void Set(FieldConvergenceData source)
        {
            Ensure.Argument.NotNull(source);

            this.Position.Set(source.Position);
            this.Ratio = source.Ratio;
            this.FollowEmitter = source.FollowEmitter;
        }

        /// <summary>
        /// オブジェクトを複製します。
        /// </summary>
        /// <returns>複製したオブジェクトです。</returns>
        public override FieldConvergenceData Clone()
        {
            return new FieldConvergenceData(this);
        }

        #endregion
    }
}
