﻿// ========================================================================
// <copyright file="ConvertUtility.cs" company="Nintendo">
//      Copyright 2009 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using NintendoWare.ToolDevelopmentKit;

namespace App.Utility

{
    /// <summary>
    /// 変換のためのユーティリティクラス。
    /// </summary>
    public static class ConvertUtility
    {
        /// <summary>
        /// 指定ファイルが不正なテクスチャファイルか調べます
        /// </summary>
        /// <returns>=true..不正</returns>
        public static bool IsIllegalTextureFile(string texFile)
        {
            string fileExt = System.IO.Path.GetExtension(texFile).ToLower();
            // 対象テクスチャの拡張子に入っているか？で調べています。
            string filter = res.Strings.UI_TEXTURE_PROPERTY_FILE_DIALOG_DRAGDROP_FILTERS;
            return (filter.IndexOf(fileExt) < 0);
        }

        /// <summary>
        /// Color -> RgbaColor
        /// </summary>
        /// <param name="color">変換元のカラーです。</param>
        /// <returns>RgbaColorオブジェクトを返します。</returns>
        public static RgbaColor ToRgbaColor(Color color)
        {
            return new RgbaColor(
                (float)color.R / 255.0f,
                (float)color.G / 255.0f,
                (float)color.B / 255.0f,
                (float)color.A / 255.0f);
        }

        /// <summary>
        /// RgbaColor -> Color
        /// </summary>
        /// <param name="color">変換元のカラーです。</param>
        /// <returns>Colorオブジェクトを返します。</returns>
        public static Color ToColor(RgbaColor color)
        {
            return Color.FromArgb(
                (int)(MathUtility.Clamp(color.A, 0.0f, 1.0f) * 255.0f),
                (int)(MathUtility.Clamp(color.R, 0.0f, 1.0f) * 255.0f),
                (int)(MathUtility.Clamp(color.G, 0.0f, 1.0f) * 255.0f),
                (int)(MathUtility.Clamp(color.B, 0.0f, 1.0f) * 255.0f));
        }
    }
}
