﻿// ========================================================================
// <copyright file="EmitterSetDocument.cs" company="Nintendo">
//      Copyright 2011 Nintendo.  All rights reserved.
// </copyright>
//
// These coded instructions, statements, and computer programs contain
// proprietary information of Nintendo of America Inc. and/or Nintendo
// Company Ltd., and are protected by Federal copyright law.  They may
// not be disclosed to third parties or copied or duplicated in any form,
// in whole or in part, without the prior written consent of Nintendo.
// ========================================================================

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NW4F.DataModel;
using App.Data;


namespace NW4F.Serializer
{
    /// <summary>
    /// エフェクト用ドキュメント
    /// </summary>
    [CoupledType(typeof(EmitterSetDocument))]
    [XmlType("EmitterSet")]
    public class EmitterSetDocumentXml : EmitterSetDataXml
    {
        #region Constructors

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EmitterSetDocumentXml()
        {
            this.EmitterList = new List<ComplexEmitterDataXml>();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EmitterSetDocumentXml( EmitterSetDocument emitterSetDoc,
                                      bool bNormalizeFilePath = true )
            : base(emitterSetDoc.EmitterSetData)
        {
            this.EmitterList = new List<ComplexEmitterDataXml>();
            foreach (var item in emitterSetDoc.EmitterDocuments)
            {
                this.EmitterList.Add( new ComplexEmitterDataXml( item.EmitterData,
                                                                 bNormalizeFilePath ) );
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EmitterSetDocumentXml(EmitterSetData emitterSet,
                                     IList<EmitterData> emitters,
                                     bool bNormalizeFilePath = true)
            : base(emitterSet)
        {
            this.EmitterList = new List<ComplexEmitterDataXml>();
            foreach (var item in emitters)
            {
                this.EmitterList.Add(new ComplexEmitterDataXml(item, bNormalizeFilePath));
            }
        }

        /// <summary>
        /// 読み込んだドキュメントを取得します。
        /// </summary>
        public EmitterSetDocument GetDocument( IProjectDocument project )
        {
            var emitterSetDoc = new EmitterSetDocument( project );
            emitterSetDoc.EmitterSetData.Set(this.EmitterSetData);

            emitterSetDoc.Name = this.name;

            foreach (var item in this.EmitterList)
            {
                item.LoadTextureFiles();
                var emitter = new EmitterDocument(emitterSetDoc, item.EditData);

                emitterSetDoc.AddEmitterDocument( emitter );
            }
            return emitterSetDoc;
        }

        #endregion
    }
}
