﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
//using App.Command;
//using App.Controls;
using App.IO;
using System.Threading;

namespace App
{
    /// <summary>
    /// Manages the UI side of the "recent files" functionality.
    /// </summary>
    public class RecentDocumentUIManager : IDisposable
    {
        private readonly SynchronizationContext _synchronizationContext;
        private readonly RecentDocumentManager _recentDocumentManager;
        //private ToolStripMenuItem _recentFilesRootMenu;
        private bool _isInitialized;

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="recentDocumentManager">The RecentDocumentManager object bound ot UI.
        /// </param>
        public RecentDocumentUIManager(RecentDocumentManager recentDocumentManager)
        {
            if (recentDocumentManager == null)
                throw new ArgumentNullException("recentDocumentManager");

            //_synchronizationContext = SynchronizationContext.Current;
            _synchronizationContext = new WindowsFormsSynchronizationContext();

            _recentDocumentManager = recentDocumentManager;
        }

        /// <summary>
        /// Initializes the RecentDocumentUIManager.
        /// </summary>
        /// <param name="recentFilesRootMenu">Root menu that holds the recent files sub menu items.
        /// </param>
        /// <param name="menuCommandHost">Instance of MenuCommandHost related to the root menu.
        /// </param>
        /*
        public void Initialize(ToolStripMenuItem recentFilesRootMenu,
            MenuCommandHost<MenuCommandID> menuCommandHost)
        {
            if (recentFilesRootMenu == null)
                throw new ArgumentNullException("recentFilesRootMenu");
            if (menuCommandHost == null)
                throw new ArgumentNullException("menuCommandHost");

            // cleanup before reinitializing
            Dispose();

            _recentFilesRootMenu = recentFilesRootMenu;
            _recentFilesRootMenu.DropDownOpening += OnRecentFilesRootMenuDropDownOpening;

            _recentDocumentManager.RecentDocumentsTrayChanged += GenerateRecentFilesMenu;

            _isInitialized = true;

            GenerateRecentFilesMenu();
        }
        */

        /// <summary>
        /// Used as RecentDocumentsTrayChanged event handler.
        /// </summary>
        /// <param name="unused">This parameter is not used.</param>
        private void GenerateRecentFilesMenu(RecentDocumentManager unused)
        {
            GenerateRecentFilesMenu();
        }

        /// <summary>
        /// Reconstruct the recent documents menu.
        /// Note: This method always runs on the UI thread.
        /// </summary>
        public void GenerateRecentFilesMenu()
        {
            _synchronizationContext.Send(_ => GenerateRecentFilesMenuUnsafe(), null);
        }

        /// <summary>
        /// Reconstruct the recent documents menu.
        /// Note: This method runs on the caller's thread.
        /// </summary>
        private void GenerateRecentFilesMenuUnsafe()
        {
            // reset the sub menu items
            //_recentFilesRootMenu.DropDownItems.Clear();

            if (Config.EmitterRecentDocuments.Documents.Length == 0)
            {
                AddNoRecentFilesMenu();
            }
            else
            {
                AddRecentFileMenus();

                // add a menu separator
                //_recentFilesRootMenu.DropDownItems.Add(new UIToolStripSeparator());

                AddClearRecentFilesMenu();
            }
        }

        /// <summary>
        /// This method updates the recent document sub menu items.
        /// It decorates the menus where the subjacent file as been deleted.
        /// </summary>
        /// <param name="sender">The instance that fired the event.</param>
        /// <param name="e">An event parameter.</param>
        private void OnRecentFilesRootMenuDropDownOpening(object sender, EventArgs e)
        {
            /*
            foreach (ToolStripItem menuItem in _recentFilesRootMenu.DropDownItems)
            {
                var file = menuItem.Tag as string;
                if (file == null)
                    continue;

                var text = System.IO.Path.GetFileName(file);
                var exists = System.IO.File.Exists(file);

                if (exists == false)
                {
                    text = string.Format("{0} [{1}]", text,
                        StringResource.Get("MENU_RECENT_FILE_NOT_FOUND"));
                }

                menuItem.Text = text;
                menuItem.Enabled = exists;
            }
            */
        }

        #region Menu generator methods

        /// <summary>
        /// This method produces the menu that indicates there are no recent docuemtns.
        /// </summary>
        private void AddNoRecentFilesMenu()
        {
            /*
            _recentFilesRootMenu.DropDownItems.Add(new UIToolStripMenuItem
            {
                Enabled = false,
                Text = StringResource.Get("MENU_NO_RECENT_FILES"),
            });
            */
        }

        /// <summary>
        /// This method produces the recent document sub menu items.
        /// </summary>
        private void AddRecentFileMenus()
        {
            /*
            foreach (var file in Config.EmitterRecentDocuments)
            {
                // TODO: Review this code

                // add the current recent file menu item
                var recentFileMenuItem = new UIToolStripMenuItem
                {
                    // Text property is updated in '' event handler
                    ToolTipText = file,
                    Tag = file,
                };

                var localFile = file;
                recentFileMenuItem.Click += (ss, ee) =>
                    DocumentIO.Command_FileRecentFilesOpen(new MenuCommandArgs(false,
                        new MenuCommandUI(recentFileMenuItem), localFile));

                _recentFilesRootMenu.DropDownItems.Add(recentFileMenuItem);
            }
            */
        }

        /// <summary>
        /// This method produces the menu that clears the recent documents list.
        /// </summary>
        private void AddClearRecentFilesMenu()
        {
            /*
            // add the "clear recent files" menu item
            var clearRecentFilesMenuItem = new UIToolStripMenuItem
            {
                Text = StringResource.Get("COMMAND_FILE_RECENT_FILES_CLEAR"),
            };
            clearRecentFilesMenuItem.Click += (s, e) => Config.EmitterRecentDocuments.Clear();
            _recentFilesRootMenu.DropDownItems.Add(clearRecentFilesMenuItem);
            */
        }

        #endregion

        /// <summary>
        /// Cleans up the RecentDocumentManager.
        /// This method unsubscribes events.
        /// </summary>
        public void Dispose()
        {
            if (_isInitialized)
            {
                _isInitialized = false;

                //_recentFilesRootMenu.DropDownOpening -= OnRecentFilesRootMenuDropDownOpening;
                _recentDocumentManager.RecentDocumentsTrayChanged -= GenerateRecentFilesMenu;
            }
        }
    }
}
