﻿
// 変数名最適化（バイナリサイズ切り詰め）
#define OPT_VARIABLE_NAME_OPTIMIZE

// ビュー関連
#ifdef OPT_VARIABLE_NAME_OPTIMIZE
#define viewMat     VWM
#define projMat     PJM
#define vpMat       VPM
#define bldMat      BLM
#define eyeVec      EVC
#define eyePos      EPS
#define viewParam   VWP
#endif

uniform mat4                    viewMat;                        //!< view        マトリクス
uniform mat4                    projMat;                        //!< proj        マトリクス
uniform mat4                    vpMat;                          //!< view * proj マトリクス
uniform mat4                    bldMat;                         //!< ビルボードマトリクス
uniform vec4                    eyeVec;                         //!< 視線ベクトル
uniform vec4                    eyePos;                         //!< 視線位置
uniform vec4                    viewParam;                      //!< near / far / near * far / far - near /

#define sysViewMatrix             viewMat                         // view matrix
#define sysProjctionMatrix        projMat                         // projection matrix
#define sysViewProjctionMatrix    vpMat                           // view * projection matrix
#define sysEyePosition            eyePos                          // eye position
#define sysScreenNear             viewParam.x                     // screen near
#define sysScreenFar              viewParam.y                     // screen far
#define sysScreenFarMultNearFar   viewParam.z                     // screen near * far
#define sysScreenSubFarNear       viewParam.w                     // screen far  - near
#define sysEyeVector              eyeVec                          // eye vector


// テクスチャ座標アニメパラメータ
uniform vec4                    tex0ScrollParam;                //!< テクスチャ0 座標アニメスクロール
uniform vec4                    tex0PatternParam;               //!< テクスチャ0 パタンアニメスクロール
uniform vec4                    tex1ScrollParam;                //!< テクスチャ1 座標アニメスクロール
uniform vec4                    tex1PatternParam;               //!< テクスチャ1 パタンアニメスクロール

uniform vec4                    particleParam;                  //!< シェーダ係数パラメータ


#define tex0ScrollAddX          tex0ScrollParam.x
#define tex0ScrollAddY          tex0ScrollParam.y
#define tex0ScaleAddX           tex0ScrollParam.z
#define tex0RotateAdd           tex0ScrollParam.w
#define tex1ScrollAddX          tex1ScrollParam.x
#define tex1ScrollAddY          tex1ScrollParam.y
#define tex1ScaleAddX           tex1ScrollParam.z
#define tex1RotateAdd           tex1ScrollParam.w


// エミッタ情報
#ifdef OPT_VARIABLE_NAME_OPTIMIZE
#define emitterColor0   EC0
#define emitterColor1   EC1
#define emitterParam0   EP0
#define emitterParam1   EP1
#define emitterMatrix   EMX
#define emitterMatrixRT EMR
#endif

uniform vec4            emitterColor0;      // エミッタカラー0
uniform vec4            emitterColor1;      // エミッタカラー1
uniform vec4            emitterParam0;      // エミッタパラメータ( time / emitterScaleX / emitterScaleY / )
uniform vec4            emitterParam1;      // エミッタパラメータ( fade alpha / emitterParticleScaleX / emitterParticleScaleY / )
uniform mat4            emitterMatrix;      // エミッタマトリクスSRT
uniform mat4            emitterMatrixRT;    // エミッタマトリクスRT

#define sysEmitterTime             emitterParam0.x            // emitter time
#define sysEmitterScaleX           emitterParam0.y            // emitter scale x
#define sysEmitterScaleY           emitterParam0.z            // emitter scale y
#define sysEmitterFadeAlpha        emitterParam1.x            // emitter fade alpha
#define sysEmitterColor0           emitterColor0              // emitter color0
#define sysEmitterColor1           emitterColor1              // emitter color1
#define sysEmitterMatrix           emitterMatrix              // emitter matrix SRT
#define sysEmitterRTMatrix         emitterMatrixRT            // emitter matrix RT
#define sysFrameRate               emitterParam0.w            // frame rate
#define sysEmitterParticleScaleX   emitterParam1.y            // emitter particle scale x
#define sysEmitterParticleScaleY   emitterParam1.z            // emitter particle scale y
#define sysEmitterParticleScaleZ   emitterParam1.w            // emitter particle scale y
#define sysEmitterParticleScaleXYZ emitterParam1.yzw          // emitter particle scale xyz


// テクスチャサンプラ
uniform sampler2D sysTextureSampler0;                   // 0枚目テクスチャサンプラ―
uniform sampler2D sysTextureSampler1;                   // 1枚目テクスチャサンプラ―
uniform sampler2D sysTextureSampler2;                   // 2枚目テクスチャサンプラ―
uniform sampler2D sysFrameBufferTexture;                // フレームバッファテクスチャサンプラ―
uniform sampler2D sysDepthBufferTexture;                // デプスバッファテクスチャサンプラ―



