﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Serializer;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_7;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.DataModel.Specific.Serializer
{
    /// <summary>
    /// Data model serializer at the current version.
    /// </summary>
    public class DataModelSerializer : DataModelSerializerBase
    {
        /// <summary>The version of the data model serializer.</summary>
        private static readonly Version SerializerVersion =
            new Version("1.0.0.8");

        /// <summary>The extra types of the current version.</summary>
        private static readonly Type[] ExtraTypes = new Type[]
        {
            typeof(CurrVersion.RandomData),
            typeof(CurrVersion.RandomFe1Data),
            typeof(CurrVersion.MagnetData),
            typeof(CurrVersion.SpinData),
            typeof(CurrVersion.ConvergeData),
            typeof(CurrVersion.AddLocationData),
            typeof(CurrVersion.CollisionData),
            typeof(CurrVersion.CurlNoiseData),
            typeof(CurrVersion.CustomFieldData),
            typeof(CurrVersion.StripeComplexData),
            typeof(CurrVersion.StripeHistoryData),
        };

        /// <summary>Maps the data model type of the previous to the current version.</summary>
        private static readonly Dictionary<Type, Type> VersionTypeMap = new Dictionary<Type, Type>
        {
            { typeof(PrevVersion.ViewerData), typeof(CurrVersion.ViewerData) },
            { typeof(PrevVersion.ViewerBackgroundData), typeof(CurrVersion.ViewerBackgroundData) },
            { typeof(PrevVersion.ModelBasicModelData), typeof(CurrVersion.ModelBasicModelData) },
            { typeof(PrevVersion.ModelBasicAnimationData), typeof(CurrVersion.ModelBasicAnimationData) },
            { typeof(PrevVersion.EmitterBasicBasicData), typeof(CurrVersion.EmitterBasicBasicData) },
            { typeof(PrevVersion.EmitterBasicRenderData), typeof(CurrVersion.EmitterBasicRenderData) },
            { typeof(PrevVersion.EmitterEmitterShapeData), typeof(CurrVersion.EmitterEmitterShapeData) },
            { typeof(PrevVersion.EmitterEmitterTransformData), typeof(CurrVersion.EmitterEmitterTransformData) },
            { typeof(PrevVersion.EmitterEmitterColorData), typeof(CurrVersion.EmitterEmitterColorData) },
            { typeof(PrevVersion.EmitterEmissionTimingData), typeof(CurrVersion.EmitterEmissionTimingData) },
            { typeof(PrevVersion.EmitterEmissionVelocityData), typeof(CurrVersion.EmitterEmissionVelocityData) },
            { typeof(PrevVersion.EmitterEmissionGravityData), typeof(CurrVersion.EmitterEmissionGravityData) },
            { typeof(PrevVersion.EmitterParticleLifeData), typeof(CurrVersion.EmitterParticleLifeData) },
            { typeof(PrevVersion.EmitterParticleRandomData), typeof(CurrVersion.EmitterParticleRandomData) },
            { typeof(PrevVersion.EmitterParticleShapeData), typeof(CurrVersion.EmitterParticleShapeData) },
            { typeof(PrevVersion.EmitterCombinerEquationData), typeof(CurrVersion.EmitterCombinerEquationData) },
            { typeof(PrevVersion.EmitterCombinerShaderData), typeof(CurrVersion.EmitterCombinerShaderData) },
            { typeof(PrevVersion.EmitterColorAlphaProcessingData), typeof(CurrVersion.EmitterColorAlphaProcessingData) },
            { typeof(PrevVersion.EmitterTextureFileData), typeof(CurrVersion.EmitterTextureFileData) },
            { typeof(PrevVersion.EmitterTextureUvAnimationData), typeof(CurrVersion.EmitterTextureUvAnimationData) },
            { typeof(PrevVersion.EmitterTexturePatternAnimationData), typeof(CurrVersion.EmitterTexturePatternAnimationData) },
            { typeof(PrevVersion.EmitterColorCalculationData), typeof(CurrVersion.EmitterColorCalculationData) },
            { typeof(PrevVersion.EmitterColorSettingsData), typeof(CurrVersion.EmitterColorSettingsData) },
            { typeof(PrevVersion.EmitterScaleBasicData), typeof(CurrVersion.EmitterScaleBasicData) },
            { typeof(PrevVersion.EmitterScaleAdditionalAnimationData), typeof(CurrVersion.EmitterScaleAdditionalAnimationData) },
            { typeof(PrevVersion.EmitterRotationBasicData), typeof(CurrVersion.EmitterRotationBasicData) },
            { typeof(PrevVersion.EmitterRotationXData), typeof(CurrVersion.EmitterRotationXData) },
            { typeof(PrevVersion.EmitterRotationYData), typeof(CurrVersion.EmitterRotationYData) },
            { typeof(PrevVersion.EmitterRotationZData), typeof(CurrVersion.EmitterRotationZData) },
            { typeof(PrevVersion.EmitterSetData), typeof(CurrVersion.EmitterSetData) },
            { typeof(PrevVersion.EmitterSetBasicData), typeof(CurrVersion.EmitterSetBasicData) },
            { typeof(PrevVersion.PreviewData), typeof(CurrVersion.PreviewData) },
            { typeof(PrevVersion.PreviewBasicFileData), typeof(CurrVersion.PreviewBasicFileData) },
            { typeof(PrevVersion.PreviewBasicPlaybackData), typeof(CurrVersion.PreviewBasicPlaybackData) },
            { typeof(PrevVersion.PreviewBasicLoadData), typeof(CurrVersion.PreviewBasicLoadData) },
            { typeof(PrevVersion.PreviewBasicSaveData), typeof(CurrVersion.PreviewBasicSaveData) },
            { typeof(PrevVersion.MagnetParamData), typeof(CurrVersion.MagnetParamData) },
            { typeof(PrevVersion.SpinParamData), typeof(CurrVersion.SpinParamData) },
            { typeof(PrevVersion.ConvergeParamData), typeof(CurrVersion.ConvergeParamData) },
            { typeof(PrevVersion.AddLocationParamData), typeof(CurrVersion.AddLocationParamData) },
            { typeof(PrevVersion.CollisionParamData), typeof(CurrVersion.CollisionParamData) },
            { typeof(PrevVersion.CurlNoiseParamData), typeof(CurrVersion.CurlNoiseParamData) },
            { typeof(PrevVersion.EmitterParticleFluctuationData), typeof(CurrVersion.EmitterParticleFluctuationData) },
            { typeof(PrevVersion.PreviewMatrixData), typeof(CurrVersion.PreviewMatrixData) },
            { typeof(PrevVersion.PreviewMatrixMatrixSettingsData), typeof(CurrVersion.PreviewMatrixMatrixSettingsData) },
            { typeof(PrevVersion.PreviewMatrixModelRelationData), typeof(CurrVersion.PreviewMatrixModelRelationData) },
            { typeof(PrevVersion.PreviewMatrixOffsetMatrixData), typeof(CurrVersion.PreviewMatrixOffsetMatrixData) },
            { typeof(PrevVersion.EmitterBasicRandomData), typeof(CurrVersion.EmitterBasicRandomData) },
            { typeof(PrevVersion.EmitterData), typeof(CurrVersion.EmitterData) },
            { typeof(PrevVersion.EmitterBasicSettingData), typeof(CurrVersion.EmitterBasicSettingData) },
            { typeof(PrevVersion.EmitterEmissionData), typeof(CurrVersion.EmitterEmissionData) },
            { typeof(PrevVersion.EmitterEmitterData), typeof(CurrVersion.EmitterEmitterData) },
            { typeof(PrevVersion.EmitterParticleData), typeof(CurrVersion.EmitterParticleData) },
            { typeof(PrevVersion.EmitterCombinerData), typeof(CurrVersion.EmitterCombinerData) },
            { typeof(PrevVersion.EmitterTextureData), typeof(CurrVersion.EmitterTextureData) },
            { typeof(PrevVersion.EmitterColorData), typeof(CurrVersion.EmitterColorData) },
            { typeof(PrevVersion.EmitterScaleData), typeof(CurrVersion.EmitterScaleData) },
            { typeof(PrevVersion.EmitterRotationData), typeof(CurrVersion.EmitterRotationData) },
            { typeof(PrevVersion.PreviewAutoMoveData), typeof(CurrVersion.PreviewAutoMoveData) },
            { typeof(PrevVersion.PreviewColorData), typeof(CurrVersion.PreviewColorData) },
            { typeof(PrevVersion.PreviewParticleEmissionData), typeof(CurrVersion.PreviewParticleEmissionData) },
            { typeof(PrevVersion.PreviewParticleScaleData), typeof(CurrVersion.PreviewParticleScaleData) },
            { typeof(PrevVersion.PreviewParticleControlData), typeof(CurrVersion.PreviewParticleControlData) },
            { typeof(PrevVersion.AddLocationData), typeof(CurrVersion.AddLocationData) },
            { typeof(PrevVersion.CollisionData), typeof(CurrVersion.CollisionData) },
            { typeof(PrevVersion.SpinData), typeof(CurrVersion.SpinData) },
            { typeof(PrevVersion.ConvergeData), typeof(CurrVersion.ConvergeData) },
            { typeof(PrevVersion.CurlNoiseData), typeof(CurrVersion.CurlNoiseData) },
            { typeof(PrevVersion.RandomData), typeof(CurrVersion.RandomData) },
            { typeof(PrevVersion.ModelBasicSettingData), typeof(CurrVersion.ModelBasicSettingData) },
            { typeof(PrevVersion.ModelData), typeof(CurrVersion.ModelData) },
            { typeof(PrevVersion.ViewerCameraData), typeof(CurrVersion.ViewerCameraData) },
            { typeof(PrevVersion.PreviewBasicSettingData), typeof(CurrVersion.PreviewBasicSettingData) },
            { typeof(PrevVersion.StripeData), typeof(CurrVersion.StripeData) },
            { typeof(PrevVersion.WorkspaceData), typeof(CurrVersion.WorkspaceData) },
            { typeof(PrevVersion.MagnetData), typeof(CurrVersion.MagnetData) },
            { typeof(PrevVersion.StripeHistoryData), typeof(CurrVersion.StripeHistoryData) },
            { typeof(PrevVersion.StripeComplexData), typeof(CurrVersion.StripeComplexData) },
            { typeof(PrevVersion.EmitterTextureGroupData), typeof(CurrVersion.EmitterTextureGroupData) },
            { typeof(PrevVersion.EmitterCustomShaderData), typeof(CurrVersion.EmitterCustomShaderData) },
            { typeof(PrevVersion.CustomActionData), typeof(CurrVersion.CustomActionData) },
            { typeof(PrevVersion.EmitterScaleAnimationCurveData), typeof(CurrVersion.EmitterScaleAnimationCurveData) },
            { typeof(PrevVersion.EmitterColorGroupData), typeof(CurrVersion.EmitterColorGroupData) },
            { typeof(PrevVersion.EmitterTextureCommonSettingsData), typeof(CurrVersion.EmitterTextureCommonSettingsData) },
            { typeof(PrevVersion.EmitterColorSettingsAnimationData), typeof(CurrVersion.EmitterColorSettingsAnimationData) },
            { typeof(PrevVersion.EmitterEmitterColorAnimationData), typeof(CurrVersion.EmitterEmitterColorAnimationData) },
            { typeof(PrevVersion.EmitterBasicInheritanceData), typeof(CurrVersion.EmitterBasicInheritanceData) },
            { typeof(PrevVersion.EmitterAnimationCommonData), typeof(CurrVersion.EmitterAnimationCommonData) },
            { typeof(PrevVersion.RandomBasicSetting), typeof(CurrVersion.RandomBasicSetting) },
            { typeof(PrevVersion.RandomDetailedOption), typeof(CurrVersion.RandomDetailedOption) },
            { typeof(PrevVersion.RandomUnifiedPhaseParam), typeof(CurrVersion.RandomUnifiedPhaseParam) },
            { typeof(PrevVersion.EmitterCombinerEditorData), typeof(CurrVersion.EmitterCombinerEditorData) },
            { typeof(PrevVersion.ViewerCameraViewProjectionData), typeof(CurrVersion.ViewerCameraViewProjectionData) },
            { typeof(PrevVersion.EmitterSetUserData), typeof(CurrVersion.EmitterSetUserData) },
            { typeof(PrevVersion.EmitterSetUserFlagData), typeof(CurrVersion.EmitterSetUserFlagData) },
            { typeof(PrevVersion.EmitterSetUserValueData), typeof(CurrVersion.EmitterSetUserValueData) },
            { typeof(PrevVersion.RandomFe1Data), typeof(CurrVersion.RandomFe1Data) },
            { typeof(PrevVersion.RandomFe1ParamData), typeof(CurrVersion.RandomFe1ParamData) },
            { typeof(PrevVersion.StripeSuperData), typeof(CurrVersion.StripeSuperData) },
            { typeof(PrevVersion.ViewerBasicData), typeof(CurrVersion.ViewerBasicData) },
            { typeof(PrevVersion.ViewerBasicSceneData), typeof(CurrVersion.ViewerBasicSceneData) },
            { typeof(PrevVersion.ReservedShaderNodeData), typeof(CurrVersion.ReservedShaderNodeData) },
            { typeof(PrevVersion.ViewerBasicPtclData), typeof(CurrVersion.ViewerBasicPtclData) },
            { typeof(PrevVersion.EmitterSetReferenceData), typeof(CurrVersion.EmitterSetReferenceData) },
            { typeof(PrevVersion.WorkspaceStorageData), typeof(CurrVersion.WorkspaceStorageData) },
            { typeof(PrevVersion.PreviewEmitterData), typeof(CurrVersion.PreviewEmitterData) },
            { typeof(PrevVersion.PreviewInstanceData), typeof(CurrVersion.PreviewInstanceData) },
            { typeof(PrevVersion.EmitterBasicLodData), typeof(CurrVersion.EmitterBasicLodData) },
            { typeof(PrevVersion.EmitterCombinerEditorAnimationCurveData), typeof(CurrVersion.EmitterCombinerEditorAnimationCurveData) },
            { typeof(PrevVersion.CustomFieldData), typeof(CurrVersion.CustomFieldData) },
            { typeof(PrevVersion.CustomFieldFlagData), typeof(CurrVersion.CustomFieldFlagData) },
            { typeof(PrevVersion.CustomFieldValueData), typeof(CurrVersion.CustomFieldValueData) },
            { typeof(PrevVersion.EmitterTextureOptionData), typeof(CurrVersion.EmitterTextureOptionData) },
            { typeof(PrevVersion.EmitterExtParams), typeof(CurrVersion.EmitterExtParams) },
        };

        /// <summary>Maps the data model type of the current to the previous version.</summary>
        private static readonly Dictionary<Type, Type> InverseVersionTypeMap = new Dictionary<Type, Type>
        {
            { typeof(CurrVersion.ViewerData), typeof(PrevVersion.ViewerData) },
            { typeof(CurrVersion.ViewerBackgroundData), typeof(PrevVersion.ViewerBackgroundData) },
            { typeof(CurrVersion.ModelBasicModelData), typeof(PrevVersion.ModelBasicModelData) },
            { typeof(CurrVersion.ModelBasicAnimationData), typeof(PrevVersion.ModelBasicAnimationData) },
            { typeof(CurrVersion.EmitterBasicBasicData), typeof(PrevVersion.EmitterBasicBasicData) },
            { typeof(CurrVersion.EmitterBasicRenderData), typeof(PrevVersion.EmitterBasicRenderData) },
            { typeof(CurrVersion.EmitterEmitterShapeData), typeof(PrevVersion.EmitterEmitterShapeData) },
            { typeof(CurrVersion.EmitterEmitterTransformData), typeof(PrevVersion.EmitterEmitterTransformData) },
            { typeof(CurrVersion.EmitterEmitterColorData), typeof(PrevVersion.EmitterEmitterColorData) },
            { typeof(CurrVersion.EmitterEmissionTimingData), typeof(PrevVersion.EmitterEmissionTimingData) },
            { typeof(CurrVersion.EmitterEmissionVelocityData), typeof(PrevVersion.EmitterEmissionVelocityData) },
            { typeof(CurrVersion.EmitterEmissionGravityData), typeof(PrevVersion.EmitterEmissionGravityData) },
            { typeof(CurrVersion.EmitterParticleLifeData), typeof(PrevVersion.EmitterParticleLifeData) },
            { typeof(CurrVersion.EmitterParticleRandomData), typeof(PrevVersion.EmitterParticleRandomData) },
            { typeof(CurrVersion.EmitterParticleShapeData), typeof(PrevVersion.EmitterParticleShapeData) },
            { typeof(CurrVersion.EmitterCombinerEquationData), typeof(PrevVersion.EmitterCombinerEquationData) },
            { typeof(CurrVersion.EmitterCombinerShaderData), typeof(PrevVersion.EmitterCombinerShaderData) },
            { typeof(CurrVersion.EmitterColorAlphaProcessingData), typeof(PrevVersion.EmitterColorAlphaProcessingData) },
            { typeof(CurrVersion.EmitterTextureFileData), typeof(PrevVersion.EmitterTextureFileData) },
            { typeof(CurrVersion.EmitterTextureUvAnimationData), typeof(PrevVersion.EmitterTextureUvAnimationData) },
            { typeof(CurrVersion.EmitterTexturePatternAnimationData), typeof(PrevVersion.EmitterTexturePatternAnimationData) },
            { typeof(CurrVersion.EmitterColorCalculationData), typeof(PrevVersion.EmitterColorCalculationData) },
            { typeof(CurrVersion.EmitterColorSettingsData), typeof(PrevVersion.EmitterColorSettingsData) },
            { typeof(CurrVersion.EmitterScaleBasicData), typeof(PrevVersion.EmitterScaleBasicData) },
            { typeof(CurrVersion.EmitterScaleAdditionalAnimationData), typeof(PrevVersion.EmitterScaleAdditionalAnimationData) },
            { typeof(CurrVersion.EmitterRotationBasicData), typeof(PrevVersion.EmitterRotationBasicData) },
            { typeof(CurrVersion.EmitterRotationXData), typeof(PrevVersion.EmitterRotationXData) },
            { typeof(CurrVersion.EmitterRotationYData), typeof(PrevVersion.EmitterRotationYData) },
            { typeof(CurrVersion.EmitterRotationZData), typeof(PrevVersion.EmitterRotationZData) },
            { typeof(CurrVersion.EmitterSetData), typeof(PrevVersion.EmitterSetData) },
            { typeof(CurrVersion.EmitterSetBasicData), typeof(PrevVersion.EmitterSetBasicData) },
            { typeof(CurrVersion.PreviewData), typeof(PrevVersion.PreviewData) },
            { typeof(CurrVersion.PreviewBasicFileData), typeof(PrevVersion.PreviewBasicFileData) },
            { typeof(CurrVersion.PreviewBasicPlaybackData), typeof(PrevVersion.PreviewBasicPlaybackData) },
            { typeof(CurrVersion.PreviewBasicLoadData), typeof(PrevVersion.PreviewBasicLoadData) },
            { typeof(CurrVersion.PreviewBasicSaveData), typeof(PrevVersion.PreviewBasicSaveData) },
            { typeof(CurrVersion.MagnetParamData), typeof(PrevVersion.MagnetParamData) },
            { typeof(CurrVersion.SpinParamData), typeof(PrevVersion.SpinParamData) },
            { typeof(CurrVersion.ConvergeParamData), typeof(PrevVersion.ConvergeParamData) },
            { typeof(CurrVersion.AddLocationParamData), typeof(PrevVersion.AddLocationParamData) },
            { typeof(CurrVersion.CollisionParamData), typeof(PrevVersion.CollisionParamData) },
            { typeof(CurrVersion.CurlNoiseParamData), typeof(PrevVersion.CurlNoiseParamData) },
            { typeof(CurrVersion.EmitterParticleFluctuationData), typeof(PrevVersion.EmitterParticleFluctuationData) },
            { typeof(CurrVersion.PreviewMatrixData), typeof(PrevVersion.PreviewMatrixData) },
            { typeof(CurrVersion.PreviewMatrixMatrixSettingsData), typeof(PrevVersion.PreviewMatrixMatrixSettingsData) },
            { typeof(CurrVersion.PreviewMatrixModelRelationData), typeof(PrevVersion.PreviewMatrixModelRelationData) },
            { typeof(CurrVersion.PreviewMatrixOffsetMatrixData), typeof(PrevVersion.PreviewMatrixOffsetMatrixData) },
            { typeof(CurrVersion.EmitterBasicRandomData), typeof(PrevVersion.EmitterBasicRandomData) },
            { typeof(CurrVersion.EmitterData), typeof(PrevVersion.EmitterData) },
            { typeof(CurrVersion.EmitterBasicSettingData), typeof(PrevVersion.EmitterBasicSettingData) },
            { typeof(CurrVersion.EmitterEmissionData), typeof(PrevVersion.EmitterEmissionData) },
            { typeof(CurrVersion.EmitterEmitterData), typeof(PrevVersion.EmitterEmitterData) },
            { typeof(CurrVersion.EmitterParticleData), typeof(PrevVersion.EmitterParticleData) },
            { typeof(CurrVersion.EmitterCombinerData), typeof(PrevVersion.EmitterCombinerData) },
            { typeof(CurrVersion.EmitterTextureData), typeof(PrevVersion.EmitterTextureData) },
            { typeof(CurrVersion.EmitterColorData), typeof(PrevVersion.EmitterColorData) },
            { typeof(CurrVersion.EmitterScaleData), typeof(PrevVersion.EmitterScaleData) },
            { typeof(CurrVersion.EmitterRotationData), typeof(PrevVersion.EmitterRotationData) },
            { typeof(CurrVersion.PreviewAutoMoveData), typeof(PrevVersion.PreviewAutoMoveData) },
            { typeof(CurrVersion.PreviewColorData), typeof(PrevVersion.PreviewColorData) },
            { typeof(CurrVersion.PreviewParticleEmissionData), typeof(PrevVersion.PreviewParticleEmissionData) },
            { typeof(CurrVersion.PreviewParticleScaleData), typeof(PrevVersion.PreviewParticleScaleData) },
            { typeof(CurrVersion.PreviewParticleControlData), typeof(PrevVersion.PreviewParticleControlData) },
            { typeof(CurrVersion.AddLocationData), typeof(PrevVersion.AddLocationData) },
            { typeof(CurrVersion.CollisionData), typeof(PrevVersion.CollisionData) },
            { typeof(CurrVersion.SpinData), typeof(PrevVersion.SpinData) },
            { typeof(CurrVersion.ConvergeData), typeof(PrevVersion.ConvergeData) },
            { typeof(CurrVersion.CurlNoiseData), typeof(PrevVersion.CurlNoiseData) },
            { typeof(CurrVersion.RandomData), typeof(PrevVersion.RandomData) },
            { typeof(CurrVersion.ModelBasicSettingData), typeof(PrevVersion.ModelBasicSettingData) },
            { typeof(CurrVersion.ModelData), typeof(PrevVersion.ModelData) },
            { typeof(CurrVersion.ViewerCameraData), typeof(PrevVersion.ViewerCameraData) },
            { typeof(CurrVersion.PreviewBasicSettingData), typeof(PrevVersion.PreviewBasicSettingData) },
            { typeof(CurrVersion.StripeData), typeof(PrevVersion.StripeData) },
            { typeof(CurrVersion.WorkspaceData), typeof(PrevVersion.WorkspaceData) },
            { typeof(CurrVersion.MagnetData), typeof(PrevVersion.MagnetData) },
            { typeof(CurrVersion.StripeHistoryData), typeof(PrevVersion.StripeHistoryData) },
            { typeof(CurrVersion.StripeComplexData), typeof(PrevVersion.StripeComplexData) },
            { typeof(CurrVersion.EmitterTextureGroupData), typeof(PrevVersion.EmitterTextureGroupData) },
            { typeof(CurrVersion.EmitterCustomShaderData), typeof(PrevVersion.EmitterCustomShaderData) },
            { typeof(CurrVersion.CustomActionData), typeof(PrevVersion.CustomActionData) },
            { typeof(CurrVersion.EmitterScaleAnimationCurveData), typeof(PrevVersion.EmitterScaleAnimationCurveData) },
            { typeof(CurrVersion.EmitterColorGroupData), typeof(PrevVersion.EmitterColorGroupData) },
            { typeof(CurrVersion.EmitterTextureCommonSettingsData), typeof(PrevVersion.EmitterTextureCommonSettingsData) },
            { typeof(CurrVersion.EmitterColorSettingsAnimationData), typeof(PrevVersion.EmitterColorSettingsAnimationData) },
            { typeof(CurrVersion.EmitterEmitterColorAnimationData), typeof(PrevVersion.EmitterEmitterColorAnimationData) },
            { typeof(CurrVersion.EmitterBasicInheritanceData), typeof(PrevVersion.EmitterBasicInheritanceData) },
            { typeof(CurrVersion.EmitterAnimationCommonData), typeof(PrevVersion.EmitterAnimationCommonData) },
            { typeof(CurrVersion.RandomBasicSetting), typeof(PrevVersion.RandomBasicSetting) },
            { typeof(CurrVersion.RandomDetailedOption), typeof(PrevVersion.RandomDetailedOption) },
            { typeof(CurrVersion.RandomUnifiedPhaseParam), typeof(PrevVersion.RandomUnifiedPhaseParam) },
            { typeof(CurrVersion.EmitterCombinerEditorData), typeof(PrevVersion.EmitterCombinerEditorData) },
            { typeof(CurrVersion.ViewerCameraViewProjectionData), typeof(PrevVersion.ViewerCameraViewProjectionData) },
            { typeof(CurrVersion.EmitterSetUserData), typeof(PrevVersion.EmitterSetUserData) },
            { typeof(CurrVersion.EmitterSetUserFlagData), typeof(PrevVersion.EmitterSetUserFlagData) },
            { typeof(CurrVersion.EmitterSetUserValueData), typeof(PrevVersion.EmitterSetUserValueData) },
            { typeof(CurrVersion.RandomFe1Data), typeof(PrevVersion.RandomFe1Data) },
            { typeof(CurrVersion.RandomFe1ParamData), typeof(PrevVersion.RandomFe1ParamData) },
            { typeof(CurrVersion.StripeSuperData), typeof(PrevVersion.StripeSuperData) },
            { typeof(CurrVersion.ViewerBasicData), typeof(PrevVersion.ViewerBasicData) },
            { typeof(CurrVersion.ViewerBasicSceneData), typeof(PrevVersion.ViewerBasicSceneData) },
            { typeof(CurrVersion.ReservedShaderNodeData), typeof(PrevVersion.ReservedShaderNodeData) },
            { typeof(CurrVersion.ViewerBasicPtclData), typeof(PrevVersion.ViewerBasicPtclData) },
            { typeof(CurrVersion.EmitterSetReferenceData), typeof(PrevVersion.EmitterSetReferenceData) },
            { typeof(CurrVersion.WorkspaceStorageData), typeof(PrevVersion.WorkspaceStorageData) },
            { typeof(CurrVersion.PreviewEmitterData), typeof(PrevVersion.PreviewEmitterData) },
            { typeof(CurrVersion.PreviewInstanceData), typeof(PrevVersion.PreviewInstanceData) },
            { typeof(CurrVersion.EmitterBasicLodData), typeof(PrevVersion.EmitterBasicLodData) },
            { typeof(CurrVersion.EmitterCombinerEditorAnimationCurveData), typeof(PrevVersion.EmitterCombinerEditorAnimationCurveData) },
            { typeof(CurrVersion.CustomFieldData), typeof(PrevVersion.CustomFieldData) },
            { typeof(CurrVersion.CustomFieldFlagData), typeof(PrevVersion.CustomFieldFlagData) },
            { typeof(CurrVersion.CustomFieldValueData), typeof(PrevVersion.CustomFieldValueData) },
            { typeof(CurrVersion.EmitterTextureOptionData), typeof(PrevVersion.EmitterTextureOptionData) },
            { typeof(CurrVersion.EmitterExtParams), typeof(PrevVersion.EmitterExtParams) },
        };

        /// <summary>
        /// Static constructor.
        /// </summary>
        static DataModelSerializer()
        {
            Instance = new DataModelSerializer();
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        private DataModelSerializer()
        {
        }

        /// <summary>
        /// Get the singleton instance for the serializer.
        /// </summary>
        public static DataModelSerializer Instance { get; private set; }

        /// <summary>
        /// Get the version of the data model serializer.
        /// </summary>
        public override Version Version
        {
            get { return SerializerVersion; }
        }

        /// <summary>
        /// Enumerate the extra data model types for serialization.
        /// </summary>
        public override IEnumerable<Type> ExtraDataModelTypes
        {
            get { return ExtraTypes; }
        }

        /// <summary>
        /// Get the dictionary that maps the data model types
        /// from the previous to the current version.
        /// </summary>
        protected override Dictionary<Type, Type> TypeMap
        {
            get { return VersionTypeMap; }
        }

        /// <summary>
        /// Get the dictionary that maps the data model types
        /// from the current to the previous version.
        /// </summary>
        protected override Dictionary<Type, Type> InverseTypeMap
        {
            get { return InverseVersionTypeMap; }
        }
    }
}
