﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_6;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_6
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/スピンタブ/スピングループデータです。
    /// </summary>
    [Serializable]
    public class SpinParamData : DataModelBase
    {
        /// <summary>
        /// 回転速度のパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData velocityAnimationTable = null;

        /// <summary>
        /// 拡散速度のパーティクル時間アニメを取得または設定します。
        /// </summary>
        private AnimationTableData outerAnimationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public SpinParamData() :
            base()
        {
            this.SpinVelocity = 2.0f;
            this.SpinAxis = 1;
            this.SpinOuter = 0.0f;
            this.EnableVelocityAnimation = 0;
            this.EnableOuterAnimation = 0;
            this.VelocityAnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.OuterAnimationTable = new AnimationTableData(new AnimationTableData(0, 0.0f, 0.0f, 0.0f, 0.0f));
            this.VelocityLoopMode = 0;
            this.OuterLoopMode = 0;
            this.VelocityLoopEnd = 100;
            this.OuterLoopEnd = 100;
            this.VelocityRandomize = 0;
            this.OuterRandomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 回転速度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("07bf2f8a-6756-4105-8d15-893c4c928c06")]
        public float SpinVelocity { get; set; }

        /// <summary>
        /// 回転軸を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("692241a0-c08d-467a-98e1-8fc02e29c083")]
        public int SpinAxis { get; set; }

        /// <summary>
        /// 拡散速度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8fdce9b0-fab2-44ac-9103-12d0f451d9b8")]
        public float SpinOuter { get; set; }

        /// <summary>
        /// 回転速度のパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("084640a7-6727-478e-b9a4-95b4dbdf65bd")]
        public int EnableVelocityAnimation { get; set; }

        /// <summary>
        /// 拡散速度のパーティクル時間アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4155a4d8-25f0-40f8-a30e-cae4adc384b4")]
        public int EnableOuterAnimation { get; set; }

        /// <summary>
        /// 回転速度のパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3b9e9d5c-c0b8-4685-842e-4ea27e67972b")]
        public AnimationTableData VelocityAnimationTable
        {
            get { return this.GetObjectFromField(ref this.velocityAnimationTable, false); }
            set { this.SetISettableToField(ref this.velocityAnimationTable, value); }
        }

        /// <summary>
        /// 拡散速度のパーティクル時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("60ca061d-4023-420c-9a5b-a3c9b5edb44d")]
        public AnimationTableData OuterAnimationTable
        {
            get { return this.GetObjectFromField(ref this.outerAnimationTable, false); }
            set { this.SetISettableToField(ref this.outerAnimationTable, value); }
        }

        /// <summary>
        /// 回転速度のパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("fd5b3e1a-f276-4ce9-9237-d3452c98fdb5")]
        public int VelocityLoopMode { get; set; }

        /// <summary>
        /// 拡散速度のパーティクル時間アニメについて再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0fcf5a29-3f45-47fe-b91b-373d0564659a")]
        public int OuterLoopMode { get; set; }

        /// <summary>
        /// 回転速度のパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたとき使用します。
        /// </summary>
        [DataModelPropertyGuid("f90c724f-434a-48df-89b0-344c4e2963d6")]
        public int VelocityLoopEnd { get; set; }

        /// <summary>
        /// 拡散速度のパーティクル時間アニメについて終端フレームを取得または設定します。
        /// 再生方法をループ再生にしたとき使用します。
        /// </summary>
        [DataModelPropertyGuid("cc885e1c-c0cf-4e72-a9d1-711a0de10a4c")]
        public int OuterLoopEnd { get; set; }

        /// <summary>
        /// 回転速度のエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c541a99b-4657-40b0-8c79-e96c0111d81e")]
        public int VelocityRandomize { get; set; }

        /// <summary>
        /// 拡散速度のエミッタ時間アニメについて開始位置のランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9c71f888-9a60-4385-8b64-f29a49f9275a")]
        public int OuterRandomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.SpinParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SpinVelocity = srcDataModel.SpinVelocity;
            this.SpinAxis = srcDataModel.SpinAxis;
            this.SpinOuter = srcDataModel.SpinOuter;
            this.EnableVelocityAnimation = srcDataModel.EnableVelocityAnimation;
            this.EnableOuterAnimation = srcDataModel.EnableOuterAnimation;
            this.VelocityAnimationTable = srcDataModel.VelocityAnimationTable;
            this.OuterAnimationTable = srcDataModel.OuterAnimationTable;
            this.VelocityLoopMode = srcDataModel.VelocityLoopMode;
            this.OuterLoopMode = srcDataModel.OuterLoopMode;
            this.VelocityLoopEnd = srcDataModel.VelocityLoopEnd;
            this.OuterLoopEnd = srcDataModel.OuterLoopEnd;
            this.VelocityRandomize = srcDataModel.VelocityRandomize;
            this.OuterRandomize = srcDataModel.OuterRandomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "SpinVelocity", this.SpinVelocity);
            this.WriteElement(context, "SpinAxis", this.SpinAxis);
            this.WriteElement(context, "SpinOuter", this.SpinOuter);
            this.WriteElement(context, "EnableVelocityAnimation", this.EnableVelocityAnimation);
            this.WriteElement(context, "EnableOuterAnimation", this.EnableOuterAnimation);
            this.WriteElement(context, "VelocityAnimationTable", this.VelocityAnimationTable);
            this.WriteElement(context, "OuterAnimationTable", this.OuterAnimationTable);
            this.WriteElement(context, "VelocityLoopMode", this.VelocityLoopMode);
            this.WriteElement(context, "OuterLoopMode", this.OuterLoopMode);
            this.WriteElement(context, "VelocityLoopEnd", this.VelocityLoopEnd);
            this.WriteElement(context, "OuterLoopEnd", this.OuterLoopEnd);
            this.WriteElement(context, "VelocityRandomize", this.VelocityRandomize);
            this.WriteElement(context, "OuterRandomize", this.OuterRandomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.SpinVelocity = this.ReadElement(context, "SpinVelocity", this.SpinVelocity);
            this.SpinAxis = this.ReadElement(context, "SpinAxis", this.SpinAxis);
            this.SpinOuter = this.ReadElement(context, "SpinOuter", this.SpinOuter);
            this.EnableVelocityAnimation = this.ReadElement(context, "EnableVelocityAnimation", this.EnableVelocityAnimation);
            this.EnableOuterAnimation = this.ReadElement(context, "EnableOuterAnimation", this.EnableOuterAnimation);
            this.VelocityAnimationTable = this.ReadElement(context, "VelocityAnimationTable", this.VelocityAnimationTable);
            this.OuterAnimationTable = this.ReadElement(context, "OuterAnimationTable", this.OuterAnimationTable);
            this.VelocityLoopMode = this.ReadElement(context, "VelocityLoopMode", this.VelocityLoopMode);
            this.OuterLoopMode = this.ReadElement(context, "OuterLoopMode", this.OuterLoopMode);
            this.VelocityLoopEnd = this.ReadElement(context, "VelocityLoopEnd", this.VelocityLoopEnd);
            this.OuterLoopEnd = this.ReadElement(context, "OuterLoopEnd", this.OuterLoopEnd);
            this.VelocityRandomize = this.ReadElement(context, "VelocityRandomize", this.VelocityRandomize);
            this.OuterRandomize = this.ReadElement(context, "OuterRandomize", this.OuterRandomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.SpinParamData(PrevVersion.SpinParamData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.SpinParamData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.SpinParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.SpinVelocity = srcDataModel.SpinVelocity;
            this.SpinAxis = srcDataModel.SpinAxis;
            this.SpinOuter = srcDataModel.SpinOuter;
            this.EnableVelocityAnimation = srcDataModel.EnableVelocityAnimation;
            this.EnableOuterAnimation = srcDataModel.EnableOuterAnimation;
            this.VelocityAnimationTable = srcDataModel.VelocityAnimationTable;
            this.OuterAnimationTable = srcDataModel.OuterAnimationTable;
            this.VelocityLoopMode = srcDataModel.VelocityLoopMode;
            this.OuterLoopMode = srcDataModel.OuterLoopMode;
            this.VelocityLoopEnd = srcDataModel.VelocityLoopEnd;
            this.OuterLoopEnd = srcDataModel.OuterLoopEnd;
            this.VelocityRandomize = srcDataModel.VelocityRandomize;
            this.OuterRandomize = srcDataModel.OuterRandomize;

            return true;
        }
    }
}
