﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// Class for preview basic file data.
    /// </summary>
    [Serializable]
    public class PreviewBasicFileData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewBasicFileData() :
            base()
        {
            this.Comment = string.Empty;
            this.LabelColor = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// ファイル名です。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("4d69fe27-785a-4608-ba25-04cf8995ecd5")]
        public string FileName
        {
            get
            {
                var prev = this.Parent.Parent as PreviewData;
                if (prev == null)
                {
                    return string.Empty;
                }

                return prev.Name;
            }
        }

        /// <summary>
        /// ファイルパスです。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("92e4d78a-6689-4afa-a378-3f36be0c0814")]
        public string FilePath
        {
            get
            {
                var prev = this.Parent.Parent as PreviewData;
                if (prev == null)
                {
                    return string.Empty;
                }

                return prev.FilePath;
            }
        }

        /// <summary>
        /// コメントです.
        /// </summary>
        [DataModelPropertyGuid("866c635e-3add-40e3-8aa7-90b344bb735f")]
        public string Comment { get; set; }

        /// <summary>
        /// ラベルカラーです.
        /// </summary>
        [DataModelPropertyGuid("3fdf830e-b456-4a9a-b075-36d442492e83")]
        public int LabelColor { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewBasicFileData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Comment = srcDataModel.Comment;
            this.LabelColor = srcDataModel.LabelColor;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Comment", this.Comment);
            this.WriteElement(context, "LabelColor", this.LabelColor);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Comment = this.ReadElement(context, "Comment", this.Comment);
            this.LabelColor = this.ReadElement(context, "LabelColor", this.LabelColor);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewBasicFileData(PrevVersion.PreviewBasicFileData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewBasicFileData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewBasicFileData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Comment = srcDataModel.Comment;
            this.LabelColor = srcDataModel.LabelColor;

            return true;
        }
    }
}
