﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/GPUノイズタブ/波形成分の詳細設定グループデータです。
    /// </summary>
    [Serializable]
    public class RandomDetailedOption : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public RandomDetailedOption() :
            base()
        {
            this.EnableDetailedOption = false;
            this.WaveAddParam0 = 4.0f;
            this.WaveAddParam1 = 3.0f;
            this.WaveAddParam2 = 2.0f;
            this.WaveAddParam3 = 1.5f;
            this.WaveCycleRate0 = 0.6f;
            this.WaveCycleRate1 = 0.42f;
            this.WaveCycleRate2 = 0.23f;
            this.WaveCycleRate3 = 0.15f;

            this.PostConstruct();
        }

        /// <summary>
        /// 各成分の設定のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b01b3b03-cc42-452c-82be-f2292c95baed")]
        public bool EnableDetailedOption { get; set; }

        /// <summary>
        /// 重み付けの成分0の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d7d0bef6-4fd0-461b-815e-16e173126b41")]
        public float WaveAddParam0 { get; set; }

        /// <summary>
        /// 重み付けの成分1の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ce4dbc0f-1740-49eb-b44e-391de2afe135")]
        public float WaveAddParam1 { get; set; }

        /// <summary>
        /// 重み付けの成分2の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d86291b1-3674-4e78-8583-16132a984452")]
        public float WaveAddParam2 { get; set; }

        /// <summary>
        /// 重み付けの成分3の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a64a406b-70e9-4147-bc65-47b89a0134d5")]
        public float WaveAddParam3 { get; set; }

        /// <summary>
        /// 比率の成分0の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a94d57d0-7160-4a19-b91a-dc785969ad84")]
        public float WaveCycleRate0 { get; set; }

        /// <summary>
        /// 比率の成分1の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ad48a8fd-c528-4284-8455-408488c5e7a5")]
        public float WaveCycleRate1 { get; set; }

        /// <summary>
        /// 比率の成分2の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d16ba26c-eb31-448d-8b30-0fb0a0c3e1f9")]
        public float WaveCycleRate2 { get; set; }

        /// <summary>
        /// 比率の成分3の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("88c70ad6-da79-493f-9178-da758ff32c86")]
        public float WaveCycleRate3 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.RandomDetailedOption;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableDetailedOption = srcDataModel.EnableDetailedOption;
            this.WaveAddParam0 = srcDataModel.WaveAddParam0;
            this.WaveAddParam1 = srcDataModel.WaveAddParam1;
            this.WaveAddParam2 = srcDataModel.WaveAddParam2;
            this.WaveAddParam3 = srcDataModel.WaveAddParam3;
            this.WaveCycleRate0 = srcDataModel.WaveCycleRate0;
            this.WaveCycleRate1 = srcDataModel.WaveCycleRate1;
            this.WaveCycleRate2 = srcDataModel.WaveCycleRate2;
            this.WaveCycleRate3 = srcDataModel.WaveCycleRate3;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableDetailedOption", this.EnableDetailedOption);
            this.WriteElement(context, "WaveAddParam0", this.WaveAddParam0);
            this.WriteElement(context, "WaveAddParam1", this.WaveAddParam1);
            this.WriteElement(context, "WaveAddParam2", this.WaveAddParam2);
            this.WriteElement(context, "WaveAddParam3", this.WaveAddParam3);
            this.WriteElement(context, "WaveCycleRate0", this.WaveCycleRate0);
            this.WriteElement(context, "WaveCycleRate1", this.WaveCycleRate1);
            this.WriteElement(context, "WaveCycleRate2", this.WaveCycleRate2);
            this.WriteElement(context, "WaveCycleRate3", this.WaveCycleRate3);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableDetailedOption = this.ReadElement(context, "EnableDetailedOption", this.EnableDetailedOption);
            this.WaveAddParam0 = this.ReadElement(context, "WaveAddParam0", this.WaveAddParam0);
            this.WaveAddParam1 = this.ReadElement(context, "WaveAddParam1", this.WaveAddParam1);
            this.WaveAddParam2 = this.ReadElement(context, "WaveAddParam2", this.WaveAddParam2);
            this.WaveAddParam3 = this.ReadElement(context, "WaveAddParam3", this.WaveAddParam3);
            this.WaveCycleRate0 = this.ReadElement(context, "WaveCycleRate0", this.WaveCycleRate0);
            this.WaveCycleRate1 = this.ReadElement(context, "WaveCycleRate1", this.WaveCycleRate1);
            this.WaveCycleRate2 = this.ReadElement(context, "WaveCycleRate2", this.WaveCycleRate2);
            this.WaveCycleRate3 = this.ReadElement(context, "WaveCycleRate3", this.WaveCycleRate3);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.RandomDetailedOption(PrevVersion.RandomDetailedOption src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.RandomDetailedOption();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.RandomDetailedOption;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EnableDetailedOption = srcDataModel.EnableDetailedOption;
            this.WaveAddParam0 = srcDataModel.WaveAddParam0;
            this.WaveAddParam1 = srcDataModel.WaveAddParam1;
            this.WaveAddParam2 = srcDataModel.WaveAddParam2;
            this.WaveAddParam3 = srcDataModel.WaveAddParam3;
            this.WaveCycleRate0 = srcDataModel.WaveCycleRate0;
            this.WaveCycleRate1 = srcDataModel.WaveCycleRate1;
            this.WaveCycleRate2 = srcDataModel.WaveCycleRate2;
            this.WaveCycleRate3 = srcDataModel.WaveCycleRate3;

            return true;
        }
    }
}
