﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_5;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_5
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/コンバイナタブ/パーティクルシェーダグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterCombinerShaderData : DataModelBase
    {
        /// <summary>
        /// 屈折/歪みの係数を取得または設定します。
        /// </summary>
        private Vector2f coefficient = null;

        /// <summary>
        /// 係数アニメのアニメーションを取得または設定します。
        /// </summary>
        private AnimationTableData coefficientAnimationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCombinerShaderData() :
            base()
        {
            this.ShaderType = 0;
            this.Coefficient = new Vector2f(0.0f, 0.0f);
            this.CoefficientAnimationTable = new AnimationTableData(new[] { new AnimationTableData.FrameValuePair(0, 1.0f, 1.0f, 1.0f, 1.0f), new AnimationTableData.FrameValuePair(25, 1.0f, 1.0f, 1.0f, 1.0f), new AnimationTableData.FrameValuePair(75, 1.0f, 1.0f, 1.0f, 1.0f), new AnimationTableData.FrameValuePair(100, 1.0f, 1.0f, 1.0f, 1.0f), });
            this.ParticleApplyAlphaValue = true;
            this.IsDistortionByCameraDistance = false;

            this.PostConstruct();
        }

        /// <summary>
        /// シェーダータイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("52df718b-e6e5-4ded-bcfa-53c84db9a3d0")]
        public int ShaderType { get; set; }

        /// <summary>
        /// 屈折/歪みの係数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("48128336-4a72-423c-b9fe-4b680232f833")]
        public Vector2f Coefficient
        {
            get { return this.GetObjectFromField(ref this.coefficient, false); }
            set { this.SetISettableToField(ref this.coefficient, value); }
        }

        /// <summary>
        /// 係数アニメのアニメーションを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2d76c03e-1aad-4219-865b-4daaf18d6cbc")]
        public AnimationTableData CoefficientAnimationTable
        {
            get { return this.GetObjectFromField(ref this.coefficientAnimationTable, false); }
            set { this.SetISettableToField(ref this.coefficientAnimationTable, value); }
        }

        /// <summary>
        /// 係数アニメのアルファ値を反映のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c0d62625-4540-4f50-a0f0-3fcd3b38946b")]
        public bool ParticleApplyAlphaValue { get; set; }

        /// <summary>
        /// カラーバッファ屈折のカメラが遠いほど強く歪む設定のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("75159b94-8f34-48e0-81fe-8cfa122c1142")]
        public bool IsDistortionByCameraDistance { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCombinerShaderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ShaderType = srcDataModel.ShaderType;
            this.Coefficient = srcDataModel.Coefficient;
            this.CoefficientAnimationTable = srcDataModel.CoefficientAnimationTable;
            this.ParticleApplyAlphaValue = srcDataModel.ParticleApplyAlphaValue;
            this.IsDistortionByCameraDistance = srcDataModel.IsDistortionByCameraDistance;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ShaderType", this.ShaderType);
            this.WriteElement(context, "Coefficient", this.Coefficient);
            this.WriteElement(context, "CoefficientAnimationTable", this.CoefficientAnimationTable);
            this.WriteElement(context, "ParticleApplyAlphaValue", this.ParticleApplyAlphaValue);
            this.WriteElement(context, "IsDistortionByCameraDistance", this.IsDistortionByCameraDistance);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ShaderType = this.ReadElement(context, "ShaderType", this.ShaderType);
            this.Coefficient = this.ReadElement(context, "Coefficient", this.Coefficient);
            this.CoefficientAnimationTable = this.ReadElement(context, "CoefficientAnimationTable", this.CoefficientAnimationTable);
            this.ParticleApplyAlphaValue = this.ReadElement(context, "ParticleApplyAlphaValue", this.ParticleApplyAlphaValue);
            this.IsDistortionByCameraDistance = this.ReadElement(context, "IsDistortionByCameraDistance", this.IsDistortionByCameraDistance);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterCombinerShaderData(PrevVersion.EmitterCombinerShaderData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterCombinerShaderData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterCombinerShaderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ShaderType = srcDataModel.ShaderType;
            this.Coefficient = srcDataModel.Coefficient;
            this.CoefficientAnimationTable = srcDataModel.CoefficientAnimationTable;
            this.ParticleApplyAlphaValue = srcDataModel.ParticleApplyAlphaValue;
            this.IsDistortionByCameraDistance = srcDataModel.IsDistortionByCameraDistance;

            return true;
        }
    }
}
