﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_4;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/スケールタブ/その他スケール設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleAdditionalAnimationData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleAdditionalAnimationData() :
            base()
        {
            this.EnableScaleVelAddY = false;
            this.ScaleVelAddY = 0.0f;
            this.EnableScalingByCameraDistNear = false;
            this.EnableScalingByCameraDistFar = false;
            this.ScaleLimitDistNear = 50.0f;
            this.ScaleLimitDistFar = 100.0f;
            this.EnableLinkFovyToScaleValue = false;

            this.PostConstruct();
        }

        /// <summary>
        /// 速度で頂点を変形のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ab943196-7e5b-4bf1-bee5-a00d30cfec7a")]
        public bool EnableScaleVelAddY { get; set; }

        /// <summary>
        /// 速度で頂点を変形の加算値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3c003fd6-0c70-4ffc-b375-6888c1462e5e")]
        public float ScaleVelAddY { get; set; }

        /// <summary>
        /// カメラ距離スケール制限（近）のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2b74d92b-377d-4b59-a101-3cb748e0b0bf")]
        public bool EnableScalingByCameraDistNear { get; set; }

        /// <summary>
        /// カメラ距離スケール制限（遠）のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("742b627a-8749-4b2e-aefa-1c2e48bf35da")]
        public bool EnableScalingByCameraDistFar { get; set; }

        /// <summary>
        /// パーティクルスケール制限距離（近）を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d9a8b4b2-6f8a-4b5f-a1d9-297e4c9c50ac")]
        public float ScaleLimitDistNear { get; set; }

        /// <summary>
        /// パーティクルスケール制限距離(遠)を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("bb582107-852a-4eff-9d6b-8f1bf3d60899")]
        public float ScaleLimitDistFar { get; set; }

        /// <summary>
        /// スケール制限に画角を連動のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0ade8903-b154-42f6-99c5-9bb63fc6e65c")]
        public bool EnableLinkFovyToScaleValue { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterScaleAdditionalAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableScaleVelAddY = srcDataModel.EnableScaleVelAddY;
            this.ScaleVelAddY = srcDataModel.ScaleVelAddY;
            this.EnableScalingByCameraDistNear = srcDataModel.EnableScalingByCameraDistNear;
            this.EnableScalingByCameraDistFar = srcDataModel.EnableScalingByCameraDistFar;
            this.ScaleLimitDistNear = srcDataModel.ScaleLimitDistNear;
            this.ScaleLimitDistFar = srcDataModel.ScaleLimitDistFar;
            this.EnableLinkFovyToScaleValue = srcDataModel.EnableLinkFovyToScaleValue;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableScaleVelAddY", this.EnableScaleVelAddY);
            this.WriteElement(context, "ScaleVelAddY", this.ScaleVelAddY);
            this.WriteElement(context, "EnableScalingByCameraDistNear", this.EnableScalingByCameraDistNear);
            this.WriteElement(context, "EnableScalingByCameraDistFar", this.EnableScalingByCameraDistFar);
            this.WriteElement(context, "ScaleLimitDistNear", this.ScaleLimitDistNear);
            this.WriteElement(context, "ScaleLimitDistFar", this.ScaleLimitDistFar);
            this.WriteElement(context, "EnableLinkFovyToScaleValue", this.EnableLinkFovyToScaleValue);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableScaleVelAddY = this.ReadElement(context, "EnableScaleVelAddY", this.EnableScaleVelAddY);
            this.ScaleVelAddY = this.ReadElement(context, "ScaleVelAddY", this.ScaleVelAddY);
            this.EnableScalingByCameraDistNear = this.ReadElement(context, "EnableScalingByCameraDistNear", this.EnableScalingByCameraDistNear);
            this.EnableScalingByCameraDistFar = this.ReadElement(context, "EnableScalingByCameraDistFar", this.EnableScalingByCameraDistFar);
            this.ScaleLimitDistNear = this.ReadElement(context, "ScaleLimitDistNear", this.ScaleLimitDistNear);
            this.ScaleLimitDistFar = this.ReadElement(context, "ScaleLimitDistFar", this.ScaleLimitDistFar);
            this.EnableLinkFovyToScaleValue = this.ReadElement(context, "EnableLinkFovyToScaleValue", this.EnableLinkFovyToScaleValue);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterScaleAdditionalAnimationData(PrevVersion.EmitterScaleAdditionalAnimationData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterScaleAdditionalAnimationData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterScaleAdditionalAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EnableScaleVelAddY = srcDataModel.EnableScaleVelAddY;
            this.ScaleVelAddY = srcDataModel.ScaleVelAddY;
            this.EnableScalingByCameraDistNear = this.ConvertProperty_EnableScalingByCameraDistNear(srcDataModel);
            this.EnableScalingByCameraDistFar = srcDataModel.EnableScalingByCameraDistFar;
            this.ScaleLimitDistNear = srcDataModel.ScaleLimitDistNear;
            this.ScaleLimitDistFar = srcDataModel.ScaleLimitDistFar;

            return true;
        }

        /// <summary>
        /// Convert EnableScalingByCameraDistNear property from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The converted value.</returns>
        public bool ConvertProperty_EnableScalingByCameraDistNear(PrevVersion.EmitterScaleAdditionalAnimationData src)
        {
            return src.EnableScalingByCameraDist;
        }
    }
}
