﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_4;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_4
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/エミッタタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmitterData : DataModelBase
    {
        /// <summary>
        /// エミッタ設定グループデータを取得または設定します。
        /// </summary>
        private EmitterEmitterShapeData emitterEmitterShapeData = null;

        /// <summary>
        /// エミッタトランスフォームグループデータを取得または設定します。
        /// </summary>
        private EmitterEmitterTransformData emitterEmitterTransformData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// エミッタ設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("80f2a4e9-274b-4097-8fdc-8b7307376b25")]
        public EmitterEmitterShapeData EmitterEmitterShapeData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmitterShapeData, false); }
            set { this.SetDataModelToField(ref this.emitterEmitterShapeData, value); }
        }

        /// <summary>
        /// エミッタトランスフォームグループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("25d6d6b5-0524-4a1b-9875-80822ab1badc")]
        public EmitterEmitterTransformData EmitterEmitterTransformData
        {
            get { return this.GetDataModelFromField(ref this.emitterEmitterTransformData, false); }
            set { this.SetDataModelToField(ref this.emitterEmitterTransformData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmitterData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterEmitterShapeData = srcDataModel.EmitterEmitterShapeData;
            this.EmitterEmitterTransformData = srcDataModel.EmitterEmitterTransformData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterEmitterShapeData", this.EmitterEmitterShapeData);
            this.WriteElement(context, "EmitterEmitterTransformData", this.EmitterEmitterTransformData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterEmitterShapeData = this.ReadElement(context, "EmitterEmitterShapeData", this.EmitterEmitterShapeData);
            this.EmitterEmitterTransformData = this.ReadElement(context, "EmitterEmitterTransformData", this.EmitterEmitterTransformData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmitterData(PrevVersion.EmitterEmitterData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmitterData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmitterData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterEmitterShapeData = srcDataModel.EmitterEmitterShapeData;
            this.EmitterEmitterTransformData = srcDataModel.EmitterEmitterTransformData;

            return true;
        }
    }
}
