﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// フィールドノード/カールノイズタブ/カールノイズグループデータです。
    /// </summary>
    [Serializable]
    public class CurlNoiseParamData : DataModelBase
    {
        /// <summary>
        /// 影響の強さを取得または設定します。
        /// </summary>
        private Vector3f curlNoiseInfluence = null;

        /// <summary>
        /// ノイズの移動速度を取得または設定します。
        /// </summary>
        private Vector3f speed = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CurlNoiseParamData() :
            base()
        {
            this.CurlNoiseInfluence = new Vector3f(0.5f, 0.5f, 0.5f);
            this.Interpolation = false;
            this.CurlNoiseScale = 1.0f;
            this.Speed = new Vector3f(0.0f, 0.0f, 0.0f);
            this.InitialValue = 1.0f;
            this.RandomOffset = true;
            this.IsWorldCoordinate = false;

            this.PostConstruct();
        }

        /// <summary>
        /// 影響の強さを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b8e595b4-0dee-41ff-b082-8fb8e066a686")]
        public Vector3f CurlNoiseInfluence
        {
            get { return this.GetObjectFromField(ref this.curlNoiseInfluence, false); }
            set { this.SetISettableToField(ref this.curlNoiseInfluence, value); }
        }

        /// <summary>
        /// ノイズテーブルを補間のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("509a439e-0429-467d-93fd-e31f7cc41c30")]
        public bool Interpolation { get; set; }

        /// <summary>
        /// ノイズのスケールを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("52c98a87-13ef-483b-b5af-80a244a969c4")]
        public float CurlNoiseScale { get; set; }

        /// <summary>
        /// ノイズの移動速度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("84e86313-5101-4a44-97de-cb905bd8acd0")]
        public Vector3f Speed
        {
            get { return this.GetObjectFromField(ref this.speed, false); }
            set { this.SetISettableToField(ref this.speed, value); }
        }

        /// <summary>
        /// ノイズのオフセットを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("15bea2e9-f25e-421d-afaa-0c43a4bb7a3e")]
        public float InitialValue { get; set; }

        /// <summary>
        /// ノイズのオフセットランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f80f0dbb-335b-4ee6-ad62-c7cb5d796fa8")]
        public bool RandomOffset { get; set; }

        /// <summary>
        /// ワールド座標で適用のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("deb7899d-4986-4c21-b8b2-2dd10cb8eede")]
        public bool IsWorldCoordinate { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CurlNoiseParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.CurlNoiseInfluence = srcDataModel.CurlNoiseInfluence;
            this.Interpolation = srcDataModel.Interpolation;
            this.CurlNoiseScale = srcDataModel.CurlNoiseScale;
            this.Speed = srcDataModel.Speed;
            this.InitialValue = srcDataModel.InitialValue;
            this.RandomOffset = srcDataModel.RandomOffset;
            this.IsWorldCoordinate = srcDataModel.IsWorldCoordinate;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "CurlNoiseInfluence", this.CurlNoiseInfluence);
            this.WriteElement(context, "Interpolation", this.Interpolation);
            this.WriteElement(context, "CurlNoiseScale", this.CurlNoiseScale);
            this.WriteElement(context, "Speed", this.Speed);
            this.WriteElement(context, "InitialValue", this.InitialValue);
            this.WriteElement(context, "RandomOffset", this.RandomOffset);
            this.WriteElement(context, "IsWorldCoordinate", this.IsWorldCoordinate);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.CurlNoiseInfluence = this.ReadElement(context, "CurlNoiseInfluence", this.CurlNoiseInfluence);
            this.Interpolation = this.ReadElement(context, "Interpolation", this.Interpolation);
            this.CurlNoiseScale = this.ReadElement(context, "CurlNoiseScale", this.CurlNoiseScale);
            this.Speed = this.ReadElement(context, "Speed", this.Speed);
            this.InitialValue = this.ReadElement(context, "InitialValue", this.InitialValue);
            this.RandomOffset = this.ReadElement(context, "RandomOffset", this.RandomOffset);
            this.IsWorldCoordinate = this.ReadElement(context, "IsWorldCoordinate", this.IsWorldCoordinate);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.CurlNoiseParamData(PrevVersion.CurlNoiseParamData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.CurlNoiseParamData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.CurlNoiseParamData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.CurlNoiseInfluence = srcDataModel.CurlNoiseInfluence;
            this.Interpolation = srcDataModel.Interpolation;
            this.CurlNoiseScale = srcDataModel.CurlNoiseScale;
            this.Speed = srcDataModel.Speed;
            this.InitialValue = srcDataModel.InitialValue;
            this.RandomOffset = srcDataModel.RandomOffset;
            this.IsWorldCoordinate = srcDataModel.IsWorldCoordinate;

            return true;
        }
    }
}
