﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/グローバル乗算カラー・アルファグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmitterColorData : DataModelBase
    {
        /// <summary>
        /// カラー0の値を取得または設定します。
        /// </summary>
        private ColorRgba color0Value = null;

        /// <summary>
        /// カラー1の値を取得または設定します。
        /// </summary>
        private ColorRgba color1Value = null;

        /// <summary>
        /// カラー0のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData color0Animation = null;

        /// <summary>
        /// カラー1のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData color1Animation = null;

        /// <summary>
        /// アルファ0のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData alpha0Animation = null;

        /// <summary>
        /// アルファ1のエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData alpha1Animation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterColorData() :
            base()
        {
            this.Color0BehaviorType = 0;
            this.Color1BehaviorType = 0;
            this.Alpha0BehaviorType = 0;
            this.Alpha1BehaviorType = 0;
            this.Color0Value = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.Color1Value = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);
            this.Alpha0Value = 1.0f;
            this.Alpha1Value = 1.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// カラー0挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("faa5ac93-c367-4dd2-aa77-8cdb036e0370")]
        public int Color0BehaviorType { get; set; }

        /// <summary>
        /// カラー1挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b10aafbb-a5b8-401e-a47f-7d3253a1b0ae")]
        public int Color1BehaviorType { get; set; }

        /// <summary>
        /// アルファ0挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b4092a56-112e-4c7d-92c5-f5ab8768acbd")]
        public int Alpha0BehaviorType { get; set; }

        /// <summary>
        /// アルファ1挙動タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d9fb9cab-cc4c-41de-8fb4-dea4fd45f594")]
        public int Alpha1BehaviorType { get; set; }

        /// <summary>
        /// カラー0の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("dd965a68-dd33-41d0-9808-d32a9da2a3ba")]
        public ColorRgba Color0Value
        {
            get { return this.GetObjectFromField(ref this.color0Value, false); }
            set { this.SetISettableToField(ref this.color0Value, value); }
        }

        /// <summary>
        /// カラー1の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1fa01116-787c-499e-869e-67c429a036c6")]
        public ColorRgba Color1Value
        {
            get { return this.GetObjectFromField(ref this.color1Value, false); }
            set { this.SetISettableToField(ref this.color1Value, value); }
        }

        /// <summary>
        /// アルファ0の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b9097d11-888f-4abb-b5aa-e0a03a0a4627")]
        public float Alpha0Value { get; set; }

        /// <summary>
        /// アルファ1の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("fd48afec-2c9b-4c94-a81c-d2e1f46dae48")]
        public float Alpha1Value { get; set; }

        /// <summary>
        /// カラー0のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b0026d3c-82f9-4eb9-a729-a46e01ed08b5")]
        public EmitterAnimationCommonData Color0Animation
        {
            get { return this.GetDataModelFromField(ref this.color0Animation, false); }
            set { this.SetDataModelToField(ref this.color0Animation, value); }
        }

        /// <summary>
        /// カラー1のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e32d33b3-bdbd-4812-be69-b6ca3ae6691b")]
        public EmitterAnimationCommonData Color1Animation
        {
            get { return this.GetDataModelFromField(ref this.color1Animation, false); }
            set { this.SetDataModelToField(ref this.color1Animation, value); }
        }

        /// <summary>
        /// アルファ0のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("246a3451-eef9-414c-8681-8b30cec3a39e")]
        public EmitterAnimationCommonData Alpha0Animation
        {
            get { return this.GetDataModelFromField(ref this.alpha0Animation, false); }
            set { this.SetDataModelToField(ref this.alpha0Animation, value); }
        }

        /// <summary>
        /// アルファ1のエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0c3fd1d4-6ae8-4ff8-8e6d-3f9cc41cf465")]
        public EmitterAnimationCommonData Alpha1Animation
        {
            get { return this.GetDataModelFromField(ref this.alpha1Animation, false); }
            set { this.SetDataModelToField(ref this.alpha1Animation, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmitterColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Color0BehaviorType = srcDataModel.Color0BehaviorType;
            this.Color1BehaviorType = srcDataModel.Color1BehaviorType;
            this.Alpha0BehaviorType = srcDataModel.Alpha0BehaviorType;
            this.Alpha1BehaviorType = srcDataModel.Alpha1BehaviorType;
            this.Color0Value = srcDataModel.Color0Value;
            this.Color1Value = srcDataModel.Color1Value;
            this.Alpha0Value = srcDataModel.Alpha0Value;
            this.Alpha1Value = srcDataModel.Alpha1Value;
            this.Color0Animation = srcDataModel.Color0Animation;
            this.Color1Animation = srcDataModel.Color1Animation;
            this.Alpha0Animation = srcDataModel.Alpha0Animation;
            this.Alpha1Animation = srcDataModel.Alpha1Animation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Color0BehaviorType", this.Color0BehaviorType);
            this.WriteElement(context, "Color1BehaviorType", this.Color1BehaviorType);
            this.WriteElement(context, "Alpha0BehaviorType", this.Alpha0BehaviorType);
            this.WriteElement(context, "Alpha1BehaviorType", this.Alpha1BehaviorType);
            this.WriteElement(context, "Color0Value", this.Color0Value);
            this.WriteElement(context, "Color1Value", this.Color1Value);
            this.WriteElement(context, "Alpha0Value", this.Alpha0Value);
            this.WriteElement(context, "Alpha1Value", this.Alpha1Value);
            this.WriteElement(context, "Color0Animation", this.Color0Animation);
            this.WriteElement(context, "Color1Animation", this.Color1Animation);
            this.WriteElement(context, "Alpha0Animation", this.Alpha0Animation);
            this.WriteElement(context, "Alpha1Animation", this.Alpha1Animation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Color0BehaviorType = this.ReadElement(context, "Color0BehaviorType", this.Color0BehaviorType);
            this.Color1BehaviorType = this.ReadElement(context, "Color1BehaviorType", this.Color1BehaviorType);
            this.Alpha0BehaviorType = this.ReadElement(context, "Alpha0BehaviorType", this.Alpha0BehaviorType);
            this.Alpha1BehaviorType = this.ReadElement(context, "Alpha1BehaviorType", this.Alpha1BehaviorType);
            this.Color0Value = this.ReadElement(context, "Color0Value", this.Color0Value);
            this.Color1Value = this.ReadElement(context, "Color1Value", this.Color1Value);
            this.Alpha0Value = this.ReadElement(context, "Alpha0Value", this.Alpha0Value);
            this.Alpha1Value = this.ReadElement(context, "Alpha1Value", this.Alpha1Value);
            this.Color0Animation = this.ReadElement(context, "Color0Animation", this.Color0Animation);
            this.Color1Animation = this.ReadElement(context, "Color1Animation", this.Color1Animation);
            this.Alpha0Animation = this.ReadElement(context, "Alpha0Animation", this.Alpha0Animation);
            this.Alpha1Animation = this.ReadElement(context, "Alpha1Animation", this.Alpha1Animation);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmitterColorData(PrevVersion.EmitterEmitterColorData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmitterColorData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmitterColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Color0BehaviorType = srcDataModel.Color0BehaviorType;
            this.Color1BehaviorType = srcDataModel.Color1BehaviorType;
            this.Alpha0BehaviorType = srcDataModel.Alpha0BehaviorType;
            this.Alpha1BehaviorType = srcDataModel.Alpha1BehaviorType;
            this.Color0Value = srcDataModel.Color0Value;
            this.Color1Value = srcDataModel.Color1Value;
            this.Alpha0Value = srcDataModel.Alpha0Value;
            this.Alpha1Value = srcDataModel.Alpha1Value;
            this.Color0Animation = srcDataModel.Color0Animation;
            this.Color1Animation = srcDataModel.Color1Animation;
            this.Alpha0Animation = srcDataModel.Alpha0Animation;
            this.Alpha1Animation = srcDataModel.Alpha1Animation;

            return true;
        }
    }
}
