﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_2;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタ時間アニメ共通のデータモデルです.
    /// </summary>
    [Serializable]
    public class EmitterAnimationCommonData : DataModelBase
    {
        /// <summary>
        /// アニメーションテーブル
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterAnimationCommonData() :
            base()
        {
            this.InterpolationMode = 0;
            this.LoopMode = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// アニメーションの有無
        /// </summary>
        [DataModelPropertyGuid("2502dfb1-1df2-419f-acf1-095e3a9abf13")]
        public bool EnableAnimation { get; set; }

        /// <summary>
        /// 補間タイプ
        /// </summary>
        [DataModelPropertyGuid("3a4aece1-b135-4509-ad42-fc8503a7c890")]
        public int InterpolationMode { get; set; }

        /// <summary>
        /// 再生タイプ
        /// </summary>
        [DataModelPropertyGuid("978261f5-5da3-4d3f-8c24-f39307f7d8e9")]
        public int LoopMode { get; set; }

        /// <summary>
        /// アニメーションテーブル
        /// </summary>
        [DataModelPropertyGuid("d1470e0c-e2fa-4fa9-a2d5-6f545f85cbd3")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterAnimationCommonData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.InterpolationMode = srcDataModel.InterpolationMode;
            this.LoopMode = srcDataModel.LoopMode;
            this.AnimationTable = srcDataModel.AnimationTable;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableAnimation", this.EnableAnimation);
            this.WriteElement(context, "InterpolationMode", this.InterpolationMode);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "AnimationTable", this.AnimationTable);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableAnimation = this.ReadElement(context, "EnableAnimation", this.EnableAnimation);
            this.InterpolationMode = this.ReadElement(context, "InterpolationMode", this.InterpolationMode);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterAnimationCommonData(PrevVersion.EmitterAnimationCommonData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterAnimationCommonData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterAnimationCommonData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EnableAnimation = srcDataModel.EnableAnimation;
            this.InterpolationMode = srcDataModel.InterpolationMode;
            this.LoopMode = srcDataModel.LoopMode;
            this.AnimationTable = srcDataModel.AnimationTable;

            return true;
        }
    }
}
