﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムフィールドの数値データです。
    /// </summary>
    [Serializable]
    public class CustomFieldValueData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomFieldValueData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// 0番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("66a7c568-0fa3-418a-8d02-27cb600eb199")]
        public float Value0 { get; set; }

        /// <summary>
        /// 1番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("9279025b-672b-403a-8da5-6cf6f3dca92f")]
        public float Value1 { get; set; }

        /// <summary>
        /// 2番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("741d5102-aec9-433d-82f9-0e5726a4036b")]
        public float Value2 { get; set; }

        /// <summary>
        /// 3番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("39d57b4b-8a69-4e1b-9156-bc929b290168")]
        public float Value3 { get; set; }

        /// <summary>
        /// 4番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("8646f988-1abd-447e-9f78-0158841a7e9b")]
        public float Value4 { get; set; }

        /// <summary>
        /// 5番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("d530c18e-c38a-473e-a89f-6a6e3f6f33c9")]
        public float Value5 { get; set; }

        /// <summary>
        /// 6番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("2fd12a4d-cc62-4fb0-acca-9ff47119182b")]
        public float Value6 { get; set; }

        /// <summary>
        /// 7番目の数値データです
        /// </summary>
        [DataModelPropertyGuid("3e45b428-c5bd-47fc-9030-aa35d93755ea")]
        public float Value7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomFieldValueData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Value0 = srcDataModel.Value0;
            this.Value1 = srcDataModel.Value1;
            this.Value2 = srcDataModel.Value2;
            this.Value3 = srcDataModel.Value3;
            this.Value4 = srcDataModel.Value4;
            this.Value5 = srcDataModel.Value5;
            this.Value6 = srcDataModel.Value6;
            this.Value7 = srcDataModel.Value7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Value0", this.Value0);
            this.WriteElement(context, "Value1", this.Value1);
            this.WriteElement(context, "Value2", this.Value2);
            this.WriteElement(context, "Value3", this.Value3);
            this.WriteElement(context, "Value4", this.Value4);
            this.WriteElement(context, "Value5", this.Value5);
            this.WriteElement(context, "Value6", this.Value6);
            this.WriteElement(context, "Value7", this.Value7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Value0 = this.ReadElement(context, "Value0", this.Value0);
            this.Value1 = this.ReadElement(context, "Value1", this.Value1);
            this.Value2 = this.ReadElement(context, "Value2", this.Value2);
            this.Value3 = this.ReadElement(context, "Value3", this.Value3);
            this.Value4 = this.ReadElement(context, "Value4", this.Value4);
            this.Value5 = this.ReadElement(context, "Value5", this.Value5);
            this.Value6 = this.ReadElement(context, "Value6", this.Value6);
            this.Value7 = this.ReadElement(context, "Value7", this.Value7);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.CustomFieldValueData(PrevVersion.CustomFieldValueData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.CustomFieldValueData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.CustomFieldValueData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Value0 = srcDataModel.Value0;
            this.Value1 = srcDataModel.Value1;
            this.Value2 = srcDataModel.Value2;
            this.Value3 = srcDataModel.Value3;
            this.Value4 = srcDataModel.Value4;
            this.Value5 = srcDataModel.Value5;
            this.Value6 = srcDataModel.Value6;
            this.Value7 = srcDataModel.Value7;

            return true;
        }
    }
}
