﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/スケールタブ/スケール（パーティクル時間アニメ）グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterScaleAnimationCurveData : DataModelBase
    {
        /// <summary>
        /// アニメーションデータを取得または設定します。
        /// </summary>
        private AnimationTableData animationTable = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterScaleAnimationCurveData() :
            base()
        {
            this.AnimationTable = new AnimationTableData(new AnimationTableData(0, 1.0f, 1.0f, 1.0f, 0.0f));
            this.LoopMode = 0;
            this.LoopEnd = 100;
            this.Randomize = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// アニメーションデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f655bd21-a7e6-45c4-998d-429c3ef2a2b0")]
        public AnimationTableData AnimationTable
        {
            get { return this.GetObjectFromField(ref this.animationTable, false); }
            set { this.SetISettableToField(ref this.animationTable, value); }
        }

        /// <summary>
        /// 再生方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2b91f6cc-4d36-4374-94e9-b2bc7c7b3669")]
        public int LoopMode { get; set; }

        /// <summary>
        /// ループ再生の終端フレーム番号を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0d2450b0-e942-434b-bbda-7aca685b6c85")]
        public int LoopEnd { get; set; }

        /// <summary>
        /// 開始位置ランダムのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("67e29ba6-93d6-42d9-8e99-b2a41b9329ea")]
        public int Randomize { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterScaleAnimationCurveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AnimationTable = srcDataModel.AnimationTable;
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AnimationTable", this.AnimationTable);
            this.WriteElement(context, "LoopMode", this.LoopMode);
            this.WriteElement(context, "LoopEnd", this.LoopEnd);
            this.WriteElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AnimationTable = this.ReadElement(context, "AnimationTable", this.AnimationTable);
            this.LoopMode = this.ReadElement(context, "LoopMode", this.LoopMode);
            this.LoopEnd = this.ReadElement(context, "LoopEnd", this.LoopEnd);
            this.Randomize = this.ReadElement(context, "Randomize", this.Randomize);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterScaleAnimationCurveData(PrevVersion.EmitterScaleAnimationCurveData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterScaleAnimationCurveData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterScaleAnimationCurveData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.AnimationTable = this.ConvertProperty_AnimationTable(srcDataModel);
            this.LoopMode = srcDataModel.LoopMode;
            this.LoopEnd = srcDataModel.LoopEnd;
            this.Randomize = srcDataModel.Randomize;

            return true;
        }

        /// <summary>
        /// Convert AnimationTable property from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The converted value.</returns>
        public AnimationTableData ConvertProperty_AnimationTable(PrevVersion.EmitterScaleAnimationCurveData src)
        {
            var emitterData = src.FindSelfOrParentOfType<PrevVersion.EmitterData>();
            System.Diagnostics.Debug.Assert(emitterData != null, "PrevVersion.EmitterDataが不正");

            // プリミティブのスケールZの種類に応じて、XかYのどちらをコピーするか切り替える.
            if (emitterData.EmitterParticleData.EmitterParticleShapeData.PrimitiveScaleZType == 0)
            {
                foreach (var keyFrame in src.AnimationTable)
                {
                    EffectMaker.Foundation.Primitives.Vector4f value = keyFrame.Value;
                    keyFrame.Value = new EffectMaker.Foundation.Primitives.Vector4f(value.X, value.Y, value.X, value.W);
                }
            }
            else
            {
                foreach (var keyFrame in src.AnimationTable)
                {
                    EffectMaker.Foundation.Primitives.Vector4f value = keyFrame.Value;
                    keyFrame.Value = new EffectMaker.Foundation.Primitives.Vector4f(value.X, value.Y, value.Y, value.W);
                }
            }

            return src.AnimationTable;
        }
    }
}
