﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/背景画像タブデータです。
    /// </summary>
    [Serializable]
    public class ViewerBackgroundData : DataModelBase
    {
        /// <summary>
        /// クリアカラーです。
        /// </summary>
        private ColorRgba clearColor = null;

        /// <summary>
        /// 背景への乗算カラーです。
        /// </summary>
        private ColorRgba multiplyColor = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBackgroundData() :
            base()
        {
            this.ClearColor = new ColorRgba(0.03f, 0.03f, 0.03f, 1.0f);
            this.ImageFilePath = string.Empty;

            this.PostConstruct();
        }

        /// <summary>
        /// クリアカラーです。
        /// </summary>
        [DataModelPropertyGuid("c2f15930-2cc7-44c0-9ce4-1b18b3f2b042")]
        public ColorRgba ClearColor
        {
            get { return this.GetObjectFromField(ref this.clearColor, false); }
            set { this.SetISettableToField(ref this.clearColor, value); }
        }

        /// <summary>
        /// 背景画像ファイルです。
        /// </summary>
        [DataModelPropertyGuid("0a7028fc-95f7-44fd-8f15-2ee1c984ddf8")]
        public string ImageFilePath { get; set; }

        /// <summary>
        /// 背景への乗算カラーです。
        /// </summary>
        [DataModelPropertyGuid("1c7de476-23a2-4eb3-87d1-7bfcce18b1c6")]
        public ColorRgba MultiplyColor
        {
            get { return this.GetObjectFromField(ref this.multiplyColor, false); }
            set { this.SetISettableToField(ref this.multiplyColor, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerBackgroundData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ClearColor = srcDataModel.ClearColor;
            this.ImageFilePath = srcDataModel.ImageFilePath;
            this.MultiplyColor = srcDataModel.MultiplyColor;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ClearColor", this.ClearColor);
            this.WriteElement(context, "ImageFilePath", this.ImageFilePath);
            this.WriteElement(context, "MultiplyColor", this.MultiplyColor);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ClearColor = this.ReadElement(context, "ClearColor", this.ClearColor);
            this.ImageFilePath = this.ReadElement(context, "ImageFilePath", this.ImageFilePath);
            this.MultiplyColor = this.ReadElement(context, "MultiplyColor", this.MultiplyColor);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ViewerBackgroundData(PrevVersion.ViewerBackgroundData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ViewerBackgroundData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ViewerBackgroundData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ClearColor = srcDataModel.ClearColor;
            this.ImageFilePath = srcDataModel.ImageFilePath;
            this.MultiplyColor = srcDataModel.MultiplyColor;

            return true;
        }
    }
}
