﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/放出タブ/その他運動設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmissionGravityData : DataModelBase
    {
        /// <summary>
        /// 重力の方向を取得または設定します。
        /// </summary>
        private Vector3f gravityDir = null;

        /// <summary>
        /// 重力のアニメーションデータセットです。
        /// </summary>
        private EmitterAnimationCommonData gravityAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmissionGravityData() :
            base()
        {
            this.EnableWorldCoordinate = false;
            this.GravityVolume = 0.0f;
            this.GravityDir = new Vector3f(0.0f, -1.0f, 0.0f);
            this.VelocityInheritRate = 0.0f;
            this.AirRegist = 1.0f;
            this.MomentumRandom = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 重力のワールド座標系適用のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("57ba2be1-c49d-4121-9658-b7f0c2f2d6fc")]
        public bool EnableWorldCoordinate { get; set; }

        /// <summary>
        /// 重力の大きさです.
        /// </summary>
        [DataModelPropertyGuid("fd6cf51f-3d47-41ae-ab8e-f0bf1b1760ca")]
        public float GravityVolume { get; set; }

        /// <summary>
        /// 重力の方向を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c15a47b8-3599-43c5-9972-9b03a4379851")]
        public Vector3f GravityDir
        {
            get { return this.GetObjectFromField(ref this.gravityDir, false); }
            set { this.SetISettableToField(ref this.gravityDir, value); }
        }

        /// <summary>
        /// 重力のアニメーションデータセットです。
        /// </summary>
        [DataModelPropertyGuid("efcfb732-12e0-4f77-9730-20b3a7e202d1")]
        public EmitterAnimationCommonData GravityAnimation
        {
            get { return this.GetDataModelFromField(ref this.gravityAnimation, false); }
            set { this.SetDataModelToField(ref this.gravityAnimation, value); }
        }

        /// <summary>
        /// エミッタ速度継承率を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f1aadb6e-ba3c-4bbe-8620-8ed7777d498f")]
        public float VelocityInheritRate { get; set; }

        /// <summary>
        /// 空気抵抗を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8e207911-a1e0-4a52-b7b3-2163ad92ad55")]
        public float AirRegist { get; set; }

        /// <summary>
        /// 運動量ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("477d6abf-2696-4139-a8ba-1d2b842f7094")]
        public float MomentumRandom { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmissionGravityData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableWorldCoordinate = srcDataModel.EnableWorldCoordinate;
            this.GravityVolume = srcDataModel.GravityVolume;
            this.GravityDir = srcDataModel.GravityDir;
            this.GravityAnimation = srcDataModel.GravityAnimation;
            this.VelocityInheritRate = srcDataModel.VelocityInheritRate;
            this.AirRegist = srcDataModel.AirRegist;
            this.MomentumRandom = srcDataModel.MomentumRandom;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableWorldCoordinate", this.EnableWorldCoordinate);
            this.WriteElement(context, "GravityVolume", this.GravityVolume);
            this.WriteElement(context, "GravityDir", this.GravityDir);
            this.WriteElement(context, "GravityAnimation", this.GravityAnimation);
            this.WriteElement(context, "VelocityInheritRate", this.VelocityInheritRate);
            this.WriteElement(context, "AirRegist", this.AirRegist);
            this.WriteElement(context, "MomentumRandom", this.MomentumRandom);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableWorldCoordinate = this.ReadElement(context, "EnableWorldCoordinate", this.EnableWorldCoordinate);
            this.GravityVolume = this.ReadElement(context, "GravityVolume", this.GravityVolume);
            this.GravityDir = this.ReadElement(context, "GravityDir", this.GravityDir);
            this.GravityAnimation = this.ReadElement(context, "GravityAnimation", this.GravityAnimation);
            this.VelocityInheritRate = this.ReadElement(context, "VelocityInheritRate", this.VelocityInheritRate);
            this.AirRegist = this.ReadElement(context, "AirRegist", this.AirRegist);
            this.MomentumRandom = this.ReadElement(context, "MomentumRandom", this.MomentumRandom);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmissionGravityData(PrevVersion.EmitterEmissionGravityData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmissionGravityData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmissionGravityData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EnableWorldCoordinate = srcDataModel.EnableWorldCoordinate;
            this.GravityVolume = srcDataModel.GravityVolume;
            this.GravityDir = srcDataModel.GravityDir;
            this.GravityAnimation = srcDataModel.GravityAnimation;
            this.VelocityInheritRate = srcDataModel.VelocityInheritRate;
            this.AirRegist = srcDataModel.AirRegist;
            this.MomentumRandom = srcDataModel.MomentumRandom;

            return true;
        }
    }
}
