﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorGroupData : DataModelBase
    {
        /// <summary>
        /// パティ―クルサブタブデータを取得または設定します。
        /// </summary>
        private EmitterColorData particleColor = null;

        /// <summary>
        /// グローバルサブタブデータを取得または設定します。
        /// </summary>
        private EmitterEmitterColorData emitterColor = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorGroupData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// パティ―クルサブタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cbe83dba-7137-4897-8f35-ae0eafb95bd1")]
        public EmitterColorData ParticleColor
        {
            get { return this.GetDataModelFromField(ref this.particleColor, false); }
            set { this.SetDataModelToField(ref this.particleColor, value); }
        }

        /// <summary>
        /// グローバルサブタブデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("28ce8f05-56ed-456f-93e8-9ce1f6749119")]
        public EmitterEmitterColorData EmitterColor
        {
            get { return this.GetDataModelFromField(ref this.emitterColor, false); }
            set { this.SetDataModelToField(ref this.emitterColor, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterColorGroupData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ParticleColor = srcDataModel.ParticleColor;
            this.EmitterColor = srcDataModel.EmitterColor;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ParticleColor", this.ParticleColor);
            this.WriteElement(context, "EmitterColor", this.EmitterColor);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ParticleColor = this.ReadElement(context, "ParticleColor", this.ParticleColor);
            this.EmitterColor = this.ReadElement(context, "EmitterColor", this.EmitterColor);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterColorGroupData(PrevVersion.EmitterColorGroupData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterColorGroupData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterColorGroupData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ParticleColor = srcDataModel.ParticleColor;
            this.EmitterColor = srcDataModel.EmitterColor;

            return true;
        }
    }
}
