﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/テクスチャタブ/テクスチャ座標アニメグループデータです。
    /// </summary>
    [Serializable]
    public class EmitterTextureUvAnimationData : DataModelBase
    {
        /// <summary>
        /// UVスクロールアニメの加算値を取得または設定します。
        /// </summary>
        private Vector2f uvScrollAddValue = null;

        /// <summary>
        /// UVスクロールアニメの初期値を取得または設定します。
        /// </summary>
        private Vector2f uvScrollInitialValue = null;

        /// <summary>
        /// UVスクロールアニメの初期値ランダムの値を取得または設定します。
        /// </summary>
        private Vector2f uvScrollInitialRandomValue = null;

        /// <summary>
        /// UVスケールアニメの加算値を取得または設定します。
        /// </summary>
        private Vector2f uvScaleAddValue = null;

        /// <summary>
        /// UVスケールアニメの初期値を取得または設定します。
        /// </summary>
        private Vector2f uvScaleInitialValue = null;

        /// <summary>
        /// UVスケールアニメの初期値ランダムの値を取得または設定します。
        /// </summary>
        private Vector2f uvScaleInitialRandomValue = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterTextureUvAnimationData() :
            base()
        {
            this.EnableUvScrollAnimation = false;
            this.EnableUvRotAnimation = false;
            this.EnableUvScaleAnimation = false;
            this.UvScrollAddValue = new Vector2f(0.0f, 0.0f);
            this.UvScrollInitialValue = new Vector2f(0.0f, 0.0f);
            this.UvScrollInitialRandomValue = new Vector2f(0.0f, 0.0f);
            this.UvRotationAddValue = 0;
            this.UvRotationInitialValue = 0;
            this.UvRotationInitialRandomValue = 0;
            this.UvScaleAddValue = new Vector2f(0.0f, 0.0f);
            this.UvScaleInitialValue = new Vector2f(1.0f, 1.0f);
            this.UvScaleInitialRandomValue = new Vector2f(0.0f, 0.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// UVスクロールアニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("462d0a1f-35dd-4519-bfe6-21912d553e14")]
        public bool EnableUvScrollAnimation { get; set; }

        /// <summary>
        /// UV回転アニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6c04e929-236d-445a-a001-af02b34fbb97")]
        public bool EnableUvRotAnimation { get; set; }

        /// <summary>
        /// UVスケールアニメのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("23974ff9-26cc-4494-be63-4db604a517ba")]
        public bool EnableUvScaleAnimation { get; set; }

        /// <summary>
        /// UVスクロールアニメの加算値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("755c9505-599b-4c9a-a1a4-2b0d4078848d")]
        public Vector2f UvScrollAddValue
        {
            get { return this.GetObjectFromField(ref this.uvScrollAddValue, false); }
            set { this.SetISettableToField(ref this.uvScrollAddValue, value); }
        }

        /// <summary>
        /// UVスクロールアニメの初期値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("515f9b88-3c9c-4ce5-beeb-f8394f24dae4")]
        public Vector2f UvScrollInitialValue
        {
            get { return this.GetObjectFromField(ref this.uvScrollInitialValue, false); }
            set { this.SetISettableToField(ref this.uvScrollInitialValue, value); }
        }

        /// <summary>
        /// UVスクロールアニメの初期値ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e2508e6a-0c9c-4d78-bfac-33fa9589ea9b")]
        public Vector2f UvScrollInitialRandomValue
        {
            get { return this.GetObjectFromField(ref this.uvScrollInitialRandomValue, false); }
            set { this.SetISettableToField(ref this.uvScrollInitialRandomValue, value); }
        }

        /// <summary>
        /// UV回転アニメの加算値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1b6f37c4-0352-4c24-b0bc-11bba56db2ed")]
        public float UvRotationAddValue { get; set; }

        /// <summary>
        /// UV回転アニメの初期値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("369a82cc-4391-4bea-9a9f-820053d2241e")]
        public float UvRotationInitialValue { get; set; }

        /// <summary>
        /// UV回転アニメの初期値ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3ba74e99-315a-4702-825e-c85f27bcddb2")]
        public float UvRotationInitialRandomValue { get; set; }

        /// <summary>
        /// UVスケールアニメの加算値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("f02abd81-835e-4dee-8d3c-27765ad45584")]
        public Vector2f UvScaleAddValue
        {
            get { return this.GetObjectFromField(ref this.uvScaleAddValue, false); }
            set { this.SetISettableToField(ref this.uvScaleAddValue, value); }
        }

        /// <summary>
        /// UVスケールアニメの初期値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("05086c12-4be1-485f-a5ba-11540e41fbdc")]
        public Vector2f UvScaleInitialValue
        {
            get { return this.GetObjectFromField(ref this.uvScaleInitialValue, false); }
            set { this.SetISettableToField(ref this.uvScaleInitialValue, value); }
        }

        /// <summary>
        /// UVスケールアニメの初期値ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("db31e5be-c6f5-4993-ad5c-e38629f3d2d7")]
        public Vector2f UvScaleInitialRandomValue
        {
            get { return this.GetObjectFromField(ref this.uvScaleInitialRandomValue, false); }
            set { this.SetISettableToField(ref this.uvScaleInitialRandomValue, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterTextureUvAnimationData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableUvScrollAnimation = srcDataModel.EnableUvScrollAnimation;
            this.EnableUvRotAnimation = srcDataModel.EnableUvRotAnimation;
            this.EnableUvScaleAnimation = srcDataModel.EnableUvScaleAnimation;
            this.UvScrollAddValue = srcDataModel.UvScrollAddValue;
            this.UvScrollInitialValue = srcDataModel.UvScrollInitialValue;
            this.UvScrollInitialRandomValue = srcDataModel.UvScrollInitialRandomValue;
            this.UvRotationAddValue = srcDataModel.UvRotationAddValue;
            this.UvRotationInitialValue = srcDataModel.UvRotationInitialValue;
            this.UvRotationInitialRandomValue = srcDataModel.UvRotationInitialRandomValue;
            this.UvScaleAddValue = srcDataModel.UvScaleAddValue;
            this.UvScaleInitialValue = srcDataModel.UvScaleInitialValue;
            this.UvScaleInitialRandomValue = srcDataModel.UvScaleInitialRandomValue;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableUvScrollAnimation", this.EnableUvScrollAnimation);
            this.WriteElement(context, "EnableUvRotAnimation", this.EnableUvRotAnimation);
            this.WriteElement(context, "EnableUvScaleAnimation", this.EnableUvScaleAnimation);
            this.WriteElement(context, "UvScrollAddValue", this.UvScrollAddValue);
            this.WriteElement(context, "UvScrollInitialValue", this.UvScrollInitialValue);
            this.WriteElement(context, "UvScrollInitialRandomValue", this.UvScrollInitialRandomValue);
            this.WriteElement(context, "UvRotationAddValue", this.UvRotationAddValue);
            this.WriteElement(context, "UvRotationInitialValue", this.UvRotationInitialValue);
            this.WriteElement(context, "UvRotationInitialRandomValue", this.UvRotationInitialRandomValue);
            this.WriteElement(context, "UvScaleAddValue", this.UvScaleAddValue);
            this.WriteElement(context, "UvScaleInitialValue", this.UvScaleInitialValue);
            this.WriteElement(context, "UvScaleInitialRandomValue", this.UvScaleInitialRandomValue);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableUvScrollAnimation = this.ReadElement(context, "EnableUvScrollAnimation", this.EnableUvScrollAnimation);
            this.EnableUvRotAnimation = this.ReadElement(context, "EnableUvRotAnimation", this.EnableUvRotAnimation);
            this.EnableUvScaleAnimation = this.ReadElement(context, "EnableUvScaleAnimation", this.EnableUvScaleAnimation);
            this.UvScrollAddValue = this.ReadElement(context, "UvScrollAddValue", this.UvScrollAddValue);
            this.UvScrollInitialValue = this.ReadElement(context, "UvScrollInitialValue", this.UvScrollInitialValue);
            this.UvScrollInitialRandomValue = this.ReadElement(context, "UvScrollInitialRandomValue", this.UvScrollInitialRandomValue);
            this.UvRotationAddValue = this.ReadElement(context, "UvRotationAddValue", this.UvRotationAddValue);
            this.UvRotationInitialValue = this.ReadElement(context, "UvRotationInitialValue", this.UvRotationInitialValue);
            this.UvRotationInitialRandomValue = this.ReadElement(context, "UvRotationInitialRandomValue", this.UvRotationInitialRandomValue);
            this.UvScaleAddValue = this.ReadElement(context, "UvScaleAddValue", this.UvScaleAddValue);
            this.UvScaleInitialValue = this.ReadElement(context, "UvScaleInitialValue", this.UvScaleInitialValue);
            this.UvScaleInitialRandomValue = this.ReadElement(context, "UvScaleInitialRandomValue", this.UvScaleInitialRandomValue);

            return success;
        }
    }
}
