﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/パーティクルタブ/パーティクル設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterParticleShapeData : DataModelBase
    {
        /// <summary>
        /// パーティクルの中心を取得または設定します。
        /// プロパティ名がアレですが無視してください。
        /// </summary>
        private Vector2f scale = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterParticleShapeData() :
            base()
        {
            this.ShapeType = 0;
            this.EnableTrimming = false;
            this.ParticleType = 0;
            this.Scale = new Vector2f(0.0f, 0.0f);
            this.CameraOffsetProcessType = 2;
            this.CameraOffsetValue = 0.0f;
            this.PrimitiveFilePath = string.Empty;
            this.PrimitiveScaleZType = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// パーティクル形状を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b013818e-bd0e-4e46-aa84-b432528060ed")]
        public int ShapeType { get; set; }

        /// <summary>
        /// トリミングのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b9201b1f-a63a-409d-bd8e-9b1c5168a62a")]
        public bool EnableTrimming { get; set; }

        /// <summary>
        /// パーティクルタイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("42daf081-d3ae-417f-bd6c-83a79036eca7")]
        public int ParticleType { get; set; }

        /// <summary>
        /// パーティクルの中心を取得または設定します。
        /// プロパティ名がアレですが無視してください。
        /// </summary>
        [DataModelPropertyGuid("9508dcb1-6f74-43bf-8ede-a4b317a6afab")]
        public Vector2f Scale
        {
            get { return this.GetObjectFromField(ref this.scale, false); }
            set { this.SetISettableToField(ref this.scale, value); }
        }

        /// <summary>
        /// パーティクルオフセットの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ae5e9bb8-1804-4d15-8970-8d088f695a1f")]
        public int CameraOffsetProcessType { get; set; }

        /// <summary>
        /// パーティクルオフセットのオフセット値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("ea5e2784-b797-4cc1-8f19-5291ed8b6e7a")]
        public float CameraOffsetValue { get; set; }

        /// <summary>
        /// プリミティブのファイルパスを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0e0ad567-ca95-443b-a07a-253afae9ba45")]
        public string PrimitiveFilePath { get; set; }

        /// <summary>
        /// プリミティブスケールZタイプです。
        /// </summary>
        [DataModelPropertyGuid("8ab7e048-cf37-44f7-949c-cbec8971ff04")]
        public int PrimitiveScaleZType { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterParticleShapeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ShapeType = srcDataModel.ShapeType;
            this.EnableTrimming = srcDataModel.EnableTrimming;
            this.ParticleType = srcDataModel.ParticleType;
            this.Scale = srcDataModel.Scale;
            this.CameraOffsetProcessType = srcDataModel.CameraOffsetProcessType;
            this.CameraOffsetValue = srcDataModel.CameraOffsetValue;
            this.PrimitiveFilePath = srcDataModel.PrimitiveFilePath;
            this.PrimitiveScaleZType = srcDataModel.PrimitiveScaleZType;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ShapeType", this.ShapeType);
            this.WriteElement(context, "EnableTrimming", this.EnableTrimming);
            this.WriteElement(context, "ParticleType", this.ParticleType);
            this.WriteElement(context, "Scale", this.Scale);
            this.WriteElement(context, "CameraOffsetProcessType", this.CameraOffsetProcessType);
            this.WriteElement(context, "CameraOffsetValue", this.CameraOffsetValue);
            this.WriteElement(context, "PrimitiveFilePath", this.PrimitiveFilePath);
            this.WriteElement(context, "PrimitiveScaleZType", this.PrimitiveScaleZType);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ShapeType = this.ReadElement(context, "ShapeType", this.ShapeType);
            this.EnableTrimming = this.ReadElement(context, "EnableTrimming", this.EnableTrimming);
            this.ParticleType = this.ReadElement(context, "ParticleType", this.ParticleType);
            this.Scale = this.ReadElement(context, "Scale", this.Scale);
            this.CameraOffsetProcessType = this.ReadElement(context, "CameraOffsetProcessType", this.CameraOffsetProcessType);
            this.CameraOffsetValue = this.ReadElement(context, "CameraOffsetValue", this.CameraOffsetValue);
            this.PrimitiveFilePath = this.ReadElement(context, "PrimitiveFilePath", this.PrimitiveFilePath);
            this.PrimitiveScaleZType = this.ReadElement(context, "PrimitiveScaleZType", this.PrimitiveScaleZType);

            return success;
        }
    }
}
