﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/基本設定タブ/描画設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterBasicRenderData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterBasicRenderData() :
            base()
        {
            this.EnableDispParticle = true;
            this.DrawPath = 0;
            this.DrawPathShaderDef1 = string.Empty;
            this.DrawPathShaderDef2 = string.Empty;
            this.DrawPathName = string.Empty;
            this.ParticleSortOrder = 0;
            this.DisplaySurface = 0;
            this.EnableTransparency = true;
            this.BlendType = 0;
            this.ZbufferAlphaTestType = 0;
            this.EnableZBufferTest = true;
            this.ZBufferTestPassType = 3;
            this.EnableZBufferWrite = false;
            this.EnableAlphaTest = true;
            this.AlphaTestPassType = 6;
            this.AlphaTestRefValue = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// パーティクル描画のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cc192167-b4d7-4ad6-9f58-49dc8b62b28a")]
        public bool EnableDispParticle { get; set; }

        /// <summary>
        /// 描画パスを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0899dfa3-117d-40b1-abc2-36ecf4f0ebc7")]
        public int DrawPath { get; set; }

        /// <summary>
        /// 描画パスに関連付けられたシェーダ定義文字列1を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6857e2b3-4e74-46a9-aa6b-614c39e9efb1")]
        public string DrawPathShaderDef1 { get; set; }

        /// <summary>
        /// 描画パスに関連付けられたシェーダ定義文字列2を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("452a321c-197e-4b2e-a8f1-8e57f102dba7")]
        public string DrawPathShaderDef2 { get; set; }

        /// <summary>
        /// 描画パス名を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d6576cd6-a60e-4a8f-9e05-1aa12fc5f954")]
        public string DrawPathName { get; set; }

        /// <summary>
        /// パーティクルソートの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5f1daae5-157c-4931-a0f4-403dc805a19b")]
        public int ParticleSortOrder { get; set; }

        /// <summary>
        /// 表示面を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0ab41910-8daa-4a2e-8cf4-b687ae4ace31")]
        public int DisplaySurface { get; set; }

        /// <summary>
        /// アルファブレンドのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2b2ed29a-c3f7-41cd-80d2-34dcece798df")]
        public bool EnableTransparency { get; set; }

        /// <summary>
        /// ブレンドプリセットを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("54a85cdf-eb38-4a82-a483-a5c6579cdcb6")]
        public int BlendType { get; set; }

        /// <summary>
        /// Zバッファ・アルファテストの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3475cacc-0a92-4386-8c37-7d6c7756153c")]
        public int ZbufferAlphaTestType { get; set; }

        /// <summary>
        /// 深度テストのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("77e7bd99-9436-44d1-8092-e64c5ca9035b")]
        public bool EnableZBufferTest { get; set; }

        /// <summary>
        /// 深度テストの通過条件を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("762c12c1-27d9-4664-911a-834049e16da8")]
        public int ZBufferTestPassType { get; set; }

        /// <summary>
        /// Zバッファ書き込みのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0df7eb2b-b6b2-4b45-9a9f-3e60bacfc528")]
        public bool EnableZBufferWrite { get; set; }

        /// <summary>
        /// アルファテストのOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("686ac0ad-da21-4358-b816-9436b1b62c3b")]
        public bool EnableAlphaTest { get; set; }

        /// <summary>
        /// アルファテスト通過タイプです。
        /// </summary>
        [DataModelPropertyGuid("c54da659-71aa-41a6-8161-6977d2eb5ba8")]
        public int AlphaTestPassType { get; set; }

        /// <summary>
        /// アルファテストの参照値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b90723ff-61df-4472-b309-a94a8e2e57f5")]
        public float AlphaTestRefValue { get; set; }

        /// <summary>
        /// バイナライズ用のブレンド設定を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("3ebb4e3e-7cb3-4fa4-ba31-0bd23f7e11ce")]
        public bool IsBlendEnable
        {
            get
            {
                switch (this.ZbufferAlphaTestType)
                {
                    case 0:
                    case 1:
                        return true;
                    case 2:
                    case 3:
                        return false;
                }

                return this.EnableTransparency;
            }
        }

        /// <summary>
        /// バイナライズ用のデプステスト設定です。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("5f819ccd-53f0-49db-a226-1de7814ae4a3")]
        public bool IsDepthTest
        {
            get
            {
                switch (this.ZbufferAlphaTestType)
                {
                    case 0:
                    case 2:
                    case 3:
                        return true;
                    case 1:
                        return false;
                }

                return this.EnableZBufferTest;
            }
        }

        /// <summary>
        /// バイナライズ用のデプス関数です。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("63ffb885-c7c0-4675-9dbb-8a8113ffa2fb")]
        public int DepthFunc
        {
            get
            {
                return this.ZbufferAlphaTestType == 4
                    ? this.ZBufferTestPassType
                    : 3;
            }
        }

        /// <summary>
        /// バイナライズ用のデプスマスクです。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("8d5fcf70-92d3-4edf-a78a-aaffcb0d60a8")]
        public bool IsDepthMask
        {
            get
            {
                switch (this.ZbufferAlphaTestType)
                {
                    case 0:
                        return false;
                    case 1:
                    case 2:
                    case 3:
                        return true;
                }

                return this.EnableZBufferWrite;
            }
        }

        /// <summary>
        /// バイナライズ用のアルファテストです。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("d11c48cf-20ca-4bd6-a082-f287936d16d1")]
        public bool IsAlphaTest
        {
            get
            {
                switch (this.ZbufferAlphaTestType)
                {
                    case 0:
                    case 1:
                    case 2:
                        return true;
                    case 3:
                        return false;
                }

                return this.EnableAlphaTest;
            }
        }

        /// <summary>
        /// バイナライズ用のアルファ関数です。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e151ea35-f10f-42d0-bd93-48bec4d202fa")]
        public int AlphaFunc
        {
            get
            {
                return this.ZbufferAlphaTestType == 4
                    ? this.AlphaTestPassType
                    : 4;
            }
        }

        /// <summary>
        /// バイナライズ用のアルファしきい値です。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("91f1d241-6d43-4dc4-ba3d-de26c8898456")]
        public float AlphaThreshold
        {
            get
            {
                switch (this.ZbufferAlphaTestType)
                {
                    case 0:
                    case 1:
                        return 0.0f;
                    case 2:
                    case 3:
                        return 0.5f;
                }

                return this.AlphaTestRefValue;
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterBasicRenderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EnableDispParticle = srcDataModel.EnableDispParticle;
            this.DrawPath = srcDataModel.DrawPath;
            this.DrawPathShaderDef1 = srcDataModel.DrawPathShaderDef1;
            this.DrawPathShaderDef2 = srcDataModel.DrawPathShaderDef2;
            this.DrawPathName = srcDataModel.DrawPathName;
            this.ParticleSortOrder = srcDataModel.ParticleSortOrder;
            this.DisplaySurface = srcDataModel.DisplaySurface;
            this.EnableTransparency = srcDataModel.EnableTransparency;
            this.BlendType = srcDataModel.BlendType;
            this.ZbufferAlphaTestType = srcDataModel.ZbufferAlphaTestType;
            this.EnableZBufferTest = srcDataModel.EnableZBufferTest;
            this.ZBufferTestPassType = srcDataModel.ZBufferTestPassType;
            this.EnableZBufferWrite = srcDataModel.EnableZBufferWrite;
            this.EnableAlphaTest = srcDataModel.EnableAlphaTest;
            this.AlphaTestPassType = srcDataModel.AlphaTestPassType;
            this.AlphaTestRefValue = srcDataModel.AlphaTestRefValue;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EnableDispParticle", this.EnableDispParticle);
            this.WriteElement(context, "DrawPath", this.DrawPath);
            this.WriteElement(context, "DrawPathShaderDef1", this.DrawPathShaderDef1);
            this.WriteElement(context, "DrawPathShaderDef2", this.DrawPathShaderDef2);
            this.WriteElement(context, "DrawPathName", this.DrawPathName);
            this.WriteElement(context, "ParticleSortOrder", this.ParticleSortOrder);
            this.WriteElement(context, "DisplaySurface", this.DisplaySurface);
            this.WriteElement(context, "EnableTransparency", this.EnableTransparency);
            this.WriteElement(context, "BlendType", this.BlendType);
            this.WriteElement(context, "ZbufferAlphaTestType", this.ZbufferAlphaTestType);
            this.WriteElement(context, "EnableZBufferTest", this.EnableZBufferTest);
            this.WriteElement(context, "ZBufferTestPassType", this.ZBufferTestPassType);
            this.WriteElement(context, "EnableZBufferWrite", this.EnableZBufferWrite);
            this.WriteElement(context, "EnableAlphaTest", this.EnableAlphaTest);
            this.WriteElement(context, "AlphaTestPassType", this.AlphaTestPassType);
            this.WriteElement(context, "AlphaTestRefValue", this.AlphaTestRefValue);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EnableDispParticle = this.ReadElement(context, "EnableDispParticle", this.EnableDispParticle);
            this.DrawPath = this.ReadElement(context, "DrawPath", this.DrawPath);
            this.DrawPathShaderDef1 = this.ReadElement(context, "DrawPathShaderDef1", this.DrawPathShaderDef1);
            this.DrawPathShaderDef2 = this.ReadElement(context, "DrawPathShaderDef2", this.DrawPathShaderDef2);
            this.DrawPathName = this.ReadElement(context, "DrawPathName", this.DrawPathName);
            this.ParticleSortOrder = this.ReadElement(context, "ParticleSortOrder", this.ParticleSortOrder);
            this.DisplaySurface = this.ReadElement(context, "DisplaySurface", this.DisplaySurface);
            this.EnableTransparency = this.ReadElement(context, "EnableTransparency", this.EnableTransparency);
            this.BlendType = this.ReadElement(context, "BlendType", this.BlendType);
            this.ZbufferAlphaTestType = this.ReadElement(context, "ZbufferAlphaTestType", this.ZbufferAlphaTestType);
            this.EnableZBufferTest = this.ReadElement(context, "EnableZBufferTest", this.EnableZBufferTest);
            this.ZBufferTestPassType = this.ReadElement(context, "ZBufferTestPassType", this.ZBufferTestPassType);
            this.EnableZBufferWrite = this.ReadElement(context, "EnableZBufferWrite", this.EnableZBufferWrite);
            this.EnableAlphaTest = this.ReadElement(context, "EnableAlphaTest", this.EnableAlphaTest);
            this.AlphaTestPassType = this.ReadElement(context, "AlphaTestPassType", this.AlphaTestPassType);
            this.AlphaTestRefValue = this.ReadElement(context, "AlphaTestRefValue", this.AlphaTestRefValue);

            return success;
        }
    }
}
