﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムアクションノードデータです。
    /// </summary>
    [Serializable]
    public class CustomActionData : WorkspaceNodeDataBase
    {
        /// <summary>
        /// 設定データリストを取得または設定します。
        /// </summary>
        private ArrayCollection<CustomActionSettingData> settings = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionData() :
            base()
        {
            this.SelectedSettingIndex = -1;

            this.PostConstruct();
        }

        /// <summary>
        /// コールバックIDを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2ca921d2-cb8b-4267-a794-4c8c7d4cbbcb")]
        public int SelectedSettingIndex { get; set; }

        /// <summary>
        /// 選択されている設定データを取得または設定します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("017af3f8-465a-4b79-ad14-efc6a13baa17")]
        public CustomActionSettingData SelectedSettingData
        {
            get
            {
                if (this.SelectedSettingIndex < 0 || this.SelectedSettingIndex > this.Settings.Count)
                {
                    return null;
                }

                return this.Settings[this.SelectedSettingIndex];
            }
        }

        /// <summary>
        /// 設定データリストを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d34f73d7-0506-40bf-9fdb-91b549ea62c4")]
        public ArrayCollection<CustomActionSettingData> Settings
        {
            get
            {
                return this.GetDataModelArrayCollectionFromField(8, ref this.settings);
            }

            set
            {
                this.SetDataModelArrayCollectionToField(8, ref this.settings, value);
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomActionData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SelectedSettingIndex = srcDataModel.SelectedSettingIndex;
            this.Settings = srcDataModel.Settings;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "SelectedSettingIndex", this.SelectedSettingIndex);
            this.WriteElement(context, "Settings", this.Settings);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.SelectedSettingIndex = this.ReadElement(context, "SelectedSettingIndex", this.SelectedSettingIndex);
            this.Settings = this.ReadElement(context, "Settings", this.Settings);

            return success;
        }
    }
}
