﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    ///
    /// </summary>
    [Serializable]
    public class EmitterCustomShaderSettingData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCustomShaderSettingData() :
            base()
        {
            this.Flags = 0;
            this.Switch0 = 0;
            this.Switch1 = 0;
            this.Switch2 = 0;
            this.Switch3 = 0;
            this.Switch4 = 0;
            this.Switch5 = 0;
            this.Switch6 = 0;
            this.Switch7 = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// 32個のビットフラグです.
        /// </summary>
        [DataModelPropertyGuid("2d5119f1-0452-450e-bb32-21db14a56097")]
        public ulong Flags { get; set; }

        /// <summary>
        /// 1個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("9a4b0301-33c8-4ca2-909d-d4f978c26098")]
        public uint Switch0 { get; set; }

        /// <summary>
        /// 2個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("eb68b0fd-7423-4d86-9f8a-95f9525f6994")]
        public uint Switch1 { get; set; }

        /// <summary>
        /// 3個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("3b2ee2b1-5c89-403a-a6a8-f031e5551c45")]
        public uint Switch2 { get; set; }

        /// <summary>
        /// 4個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("c1130e61-7678-435c-a05a-e6191b64d8a4")]
        public uint Switch3 { get; set; }

        /// <summary>
        /// 5個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("7c3a2e51-f325-48a2-be76-aa486f292fa1")]
        public uint Switch4 { get; set; }

        /// <summary>
        /// 6個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("0b7c75fc-cc5e-47c5-9c8d-1636b01b7ac8")]
        public uint Switch5 { get; set; }

        /// <summary>
        /// 7個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("9fb2f57f-2348-40b9-aade-2364cb989da9")]
        public uint Switch6 { get; set; }

        /// <summary>
        /// 8個目のラジオボタンによるスイッチ選択状態です。
        /// </summary>
        [DataModelPropertyGuid("a5b4e188-bcd9-4334-9117-82d6bf38924a")]
        public uint Switch7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCustomShaderSettingData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Flags = srcDataModel.Flags;
            this.Switch0 = srcDataModel.Switch0;
            this.Switch1 = srcDataModel.Switch1;
            this.Switch2 = srcDataModel.Switch2;
            this.Switch3 = srcDataModel.Switch3;
            this.Switch4 = srcDataModel.Switch4;
            this.Switch5 = srcDataModel.Switch5;
            this.Switch6 = srcDataModel.Switch6;
            this.Switch7 = srcDataModel.Switch7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Flags", this.Flags);
            this.WriteElement(context, "Switch0", this.Switch0);
            this.WriteElement(context, "Switch1", this.Switch1);
            this.WriteElement(context, "Switch2", this.Switch2);
            this.WriteElement(context, "Switch3", this.Switch3);
            this.WriteElement(context, "Switch4", this.Switch4);
            this.WriteElement(context, "Switch5", this.Switch5);
            this.WriteElement(context, "Switch6", this.Switch6);
            this.WriteElement(context, "Switch7", this.Switch7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Flags = this.ReadElement(context, "Flags", this.Flags);
            this.Switch0 = this.ReadElement(context, "Switch0", this.Switch0);
            this.Switch1 = this.ReadElement(context, "Switch1", this.Switch1);
            this.Switch2 = this.ReadElement(context, "Switch2", this.Switch2);
            this.Switch3 = this.ReadElement(context, "Switch3", this.Switch3);
            this.Switch4 = this.ReadElement(context, "Switch4", this.Switch4);
            this.Switch5 = this.ReadElement(context, "Switch5", this.Switch5);
            this.Switch6 = this.ReadElement(context, "Switch6", this.Switch6);
            this.Switch7 = this.ReadElement(context, "Switch7", this.Switch7);

            return success;
        }
    }
}
