﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.AnimationTable;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// RandomBasicSettingViewModel.
    /// </summary>
    public class RandomBasicSettingViewModel : CurveEditorOwnerViewModel<RandomBasicSetting>, IModificationFlagOwner
    {
        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public RandomBasicSettingViewModel(HierarchyViewModel parent, RandomBasicSetting dataModel)
            : base(parent, dataModel)
        {
            this.SetDefaultSnapSetting("FieldRandomBasic");
            this.DefaultValue = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            var table = this.GetDataModelValue<AnimationTableData>("AnimationTable");
            if (table.Count == 0)
            {
                this.InitData();
            }

            // デフォルト値を更新
            this.UpdatePropertyDescriptors();

            var randomCurveProperties = EnumerableUtility.Enumerate(
                    ViewModelBase.NameOf(() => dataModel.EnableAnimation),
                    ViewModelBase.NameOf(() => dataModel.AnimationTable),
                    ViewModelBase.NameOf(() => dataModel.LoopMode),
                    ViewModelBase.NameOf(() => dataModel.LoopEnd),
                    ViewModelBase.NameOf(() => dataModel.Randomize),
                    ViewModelBase.NameOf(() => dataModel.RandomVel));

            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            var mmfvm = new MultipleModificationFlagsViewModel(this);
            mmfvm.SetPropertyDictionary("RandomCurve", randomCurveProperties);
            this.ModificationFlagViewModel = mmfvm;

            // データ変更フラグをクリア。
            this.ModificationFlagViewModel.ClearModificationFlags();
            this.ModificationFlagViewModel.ClearChildModificationFlags();
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }
    }
}
